@extends('dashboard.master')
@section('title', 'Due-Advance Collect')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
    .ui-datepicker-calendar {
        display: none;
    }
    #student_id {
        text-align: center;
    }
    .select2-container .select2-selection--single {
        height: 38px;
    }
    .select2-container--default .select2-selection--multiple {
        height: 38px;
    }
</style>
@endpush

@section('content')
@php
    $start = \Carbon\Carbon::create(2025, 1, 1);
    $end = \Carbon\Carbon::now()->addYears(50)->startOfMonth();
@endphp
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Due-Advance Collect</b></span>
                </div>
                <div class="page-title-actions">
                    <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">

                    @if(session('error'))
                        <div class="alert alert-danger mt-2">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form enctype="multipart/form-data" action="{{ route('student.payment.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-sm-5">
                                <div class="form-group">
                                    <label for="student_id">Student</label>
                                    <select name="student_id" id="student_id" class="form-control @error('student_id') is-invalid @enderror">
                                        <option value="">Select One</option>
                                        @foreach ($students as $key => $student)
                                            <option value="{{ $student->id }}" data-class_id="{{ $student->class_id }}" data-session_id="{{ $student->session_id }}">{{ $student->name ?? '' }} | {{ $student->register_no ?? '' }} | {{ $student->stuclass->name ?? '' }} |
                                                @if($student->student_type == 1)
                                                অনাবাসিক
                                                @elseif($student->student_type == 2)
                                                আবাসিক
                                                @endif
                                                {{ !empty($student->monthly_dis) ? ' | ' . $student->monthly_dis . ' TK' : '' }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('student_id')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-5">
                                <div class="form-group">
                                    <label for="months">Months<span class="text-red">*</span></label>
                                    <select name="months[]" id="months" class="form-control select2" multiple="multiple" required>
                                        @for ($date = $start->copy(); $date <= $end; $date->addMonth())
                                            <option value="{{ $date->format('F-Y') }}">{{ $date->format('F Y') }}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label for="amount">Total Amount </label>
                                    <input type="number" name="total_amount" id="total_amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" readonly>

                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control" required>
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label for="amount">Receive Amount <span class="text-red">*</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" required>
                                    @error('amount')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label for="amount">Discount Amount</label>
                                    <input type="number" name="discount" id="discount" value="{{ old('discount') }}" class="form-control" placeholder="amount" >
                                </div>
                            </div>

                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label for="amount">Total Due</label>
                                    <input type="number" name="due_amount" id="due_amount" data-amount="{{ old('amount') }}" value="{{ old('due_amount') }}" class="form-control" placeholder="amount" readonly>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="note">Note</label>
                                    <textarea name="note" id="note" cols="1" rows="1" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>
                    </form>

                    <div class="col-md-12 mt-4 table-responsive">
                        <table id="fee_table" class="table table-bordered table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Month</th>

                                    <th>Resident Fee</th>
                                    <th>Non-Resident Fee</th>
                                     <th>Academic Fee</th>
                                    <th>Other Fee</th>
                                    <th>Special Fee</th>
                                    <th>Total Received</th>
                                    <th>Total Discount</th>
                                    <th>Total Due</th>
                                </tr>
                            </thead>
                            <tbody id="fee_table_body">
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="2">Total</th>

                                    <th id="total_hostel">0</th>
                                    <th id="total_onabashik">0</th>
                                    <th id="total_academic">0</th>
                                    <th id="total_other">0</th>
                                    <th id="total_special">0</th>
                                    <th id="total_received">0</th>
                                    <th id="total_discount">0</th>
                                    <th id="total_due">0</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
$('.mt-4').hide();
$(document).ready(function() {
    $('#student_id, #months').select2();

    $('#student_id').on('change', function() {
        loadFeeData();
    });

    $('#months').on('change', function() {
        $('.mt-4').show();
        loadFeeData();
    });

    function loadFeeData() {
    var student_id = $('#student_id').val();
    var months = $('#months').val();

    if(student_id && months && months.length > 0) {
        $.ajax({
            url: "{{ route('student.monthly.payment') }}",
            type: 'POST',
            data: {
                months: months,
                student_id: student_id,
                class_id: $('#student_id').find(':selected').data('class_id'),
                session_id: $('#student_id').find(':selected').data('session_id'),
                _token: '{{ csrf_token() }}'
            },
            success: function(data) {
                $('#fee_table_body').empty();
                console.log(data);

                $.each(data.monthlyData, function(index, item) {
                    $('#fee_table_body').append(`
                        <tr>
                            <td>${index + 1}</td>
                            <td>${item.month}</td>

                            <td>${item.hostelFee}</td>
                            <td>${item.onabashikFee}</td>
                             <td>${item.academicFee}</td>
                            <td>${item.otherFee}</td>
                            <td>${item.specialFee}</td>
                            <td>${item.totalReceived}</td>
                            <td>${item.totalDiscount}</td>
                            <td>${item.due}</td>
                        </tr>
                    `);
                });

                $('#total_academic').text(data.totalAcademic);
                $('#total_hostel').text(data.totalHostel);
                $('#total_onabashik').text(data.totalOnabashik);
                $('#total_other').text(data.totalOther);
                $('#total_special').text(data.totalSpecial);
                $('#total_received').text(data.totalReceived);
                $('#total_discount').text(data.totalDiscount);
                $('#total_due').text(data.totalDue);

                $('#due_amount').val(data.totalDue);
                $("#due_amount").attr('data-amount', data.totalDue);
                const totalAmount = parseFloat(data.totalAcademic || 0) +
                                parseFloat(data.totalHostel || 0) +
                                parseFloat(data.totalOther || 0) +
                                 parseFloat(data.totalOnabashik || 0) +
                                  parseFloat(data.totalSpecial || 0);

                $('#total_amount').val(totalAmount);
            }
        });
    }
}

    $(document).on('keyup', '#amount, #discount', function() {
        var amount = parseFloat($('#amount').val()) || 0;
        var discount = parseFloat($('#discount').val()) || 0;
        var due = parseFloat($('#due_amount').attr('data-amount')) || parseFloat($('#due_amount').val()) || 0;

        if((amount + discount) > due) {
            alert('Amount cannot be greater than due amount');
            $(this).val('');
            return;
        }
        $('#due_amount').val(due - (amount + discount));
    });
});

    @if(Session::has('success'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "timeOut": 2000
        };
        toastr.success("{{ session('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        };
        toastr.error("{{ session('error') }}");
    @endif
</script>

@endpush
@endsection
