@extends('dashboard.master')
@section('title', 'Edit Payment Receive')

@push('css')
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <style>
        .ui-datepicker-calendar {
            display: none;
        }

        #student_id {
            text-align: center;
        }

        .select2-container .select2-selection--single {
            height: 38px;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Edit Payment Receive</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">

                        @if (session('error'))
                            <div class="alert alert-danger mt-2">
                                {{ session('error') }}
                            </div>
                        @endif

                        <form enctype="multipart/form-data" action="{{ route('payment.update', $data->id) }}" method="POST">
                            @csrf
                            <div class="row">

                                <div class="col-sm-12" id="payment_info" style="display: none;">
                                    <label id="total_received_label"></label>
                                    <br>
                                    <label id="total_discount_label"></label>
                                    <br>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="class_id">Class<span class="text-red">*</span></label>
                                        <input type="text" class="form-control" value="{{ $data->class_name ?? '' }}"
                                            readonly>
                                        <input type="hidden" name="class_id" id="class_id" class="form-control"
                                            value="{{ $data->class_id }}" readonly>

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="student_id">Student</label>
                                        <input type="text" class="form-control" value="{{ $data->student_name ?? '' }}"
                                            readonly>
                                        <input type="hidden" name="student_id" id="student_id" class="form-control"
                                            value="{{ $data->student_id ?? '' }}" readonly>

                                    </div>
                                </div>

                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="month">Month<span class="text-red">*</span></label>
                                        <input type="text"
                                            value="{{ \Carbon\Carbon::parse($data->month)->format('F-Y') }}"
                                            class="form-control datepicker @error('month') is-invalid @enderror" readonly>
                                        <input type="hidden" name="month" id="month" class="form-control "
                                            value="{{ $data->month }}">


                                    </div>
                                </div>



                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="amount">Total Amount</label>
                                        <input type="number" name="total_amount" id="total_amount"
                                            value="{{ old('amount', $data->total_amount) }}"
                                            class="form-control @error('amount') is-invalid @enderror" placeholder="amount"
                                            readonly>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>SL</th>
                                                <th>Details</th>
                                                <th>Amount</th>
                                                {{-- <th>Fund</th> --}}
                                                <th>Total</th>
                                                <th>Previous Received</th>
                                                <th>Previous Discount</th>
                                                <th>Receive</th>
                                                <th>Discount</th>
                                                <th>Due</th>

                                            </tr>
                                        </thead>
                                        <tbody id="payment_details">
                                            

                                            @if ($fundDetailType && count($fundDetailType) > 0)
                                                @foreach ($fundDetailType as $key => $fundDetail)
                                                    <tr>
                                                        <td>
                                                            <input type="hidden"
                                                                name="rows[{{ $fundDetail->fee_type }}][enabled]"
                                                                class="row-enable" value="1">

                                                               <input type="Checkbox"
                                                                name="rows[{{ $fundDetail->fee_type }}][enabled]"
                                                                class="row-enable" value="1" checked="" disabled>
                                                                
                                                                
                                                                <input type="hidden"
                                                                name="rows[{{ $fundDetail->fee_type }}][id]"
                                                                class="row-enable" value="{{ $fundDetail->id }}">
                                                        </td>
                                                        <td>{{ ucfirst($fundDetail->fee_type) }}</td>

                                                        <td>
                                                            <ul
                                                                style="list-style: none; padding-left: 0px; margin-left: 20px;">
                                                                @if ($fundDetail->details)
                                                                    @foreach ($fundDetail->details as $Key => $detail)
                                                                
                                                                    <input type="hidden" name="detail_id_{{ $fundDetail->fee_type }}[]" value="{{ $detail->fd_id }}">
                                                                        <input type="hidden"
                                                                            name="fund_id_{{ $fundDetail->fee_type }}fee_amount[{{ $detail->fee_id }}]"
                                                                            value="{{ $detail->amount }}">
                                                                        <li
                                                                            style="display:flex; align-items:center; justify-content:space-between;">
                                                                            {{ $detail->fee_name }}: {{ $detail->amount }}
                                                                            <select
                                                                                id="fund_id_{{ $fundDetail->fee_type }}"
                                                                                name="fund_id_{{ $fundDetail->fee_type }}[{{ $detail->fee_id }}]"
                                                                                class="form-control"
                                                                                style="display:inline-block; width:auto;"
                                                                                required="">
                                                                                <option value="">Select fund</option>
                                                                                @foreach ($funds as $fund)
                                                                                    <option value="{{ $fund->id }}"
                                                                                        @if ($detail->fund_id == $fund->id) selected @endif>
                                                                                        {{ $fund->name ?? '' }}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </li>
                                                                    @endforeach
                                                                @endif

                                                            </ul>
                                                        </td>

                                                        <td id="{{ $fundDetail->fee_type }}_amount_total">
                                                            {{ $fundDetail->total }}</td>
                                                        <input type="hidden"
                                                            name="{{ $fundDetail->fee_type }}_amount_total"
                                                            id="{{ $fundDetail->fee_type }}_amount_total"
                                                            value="{{ $fundDetail->total }}">

                                                        <td id="{{ $fundDetail->fee_type }}_receive_total">
                                                            {{ $fundDetail->prev_receive ?? 0 }}</td>
                                                            <input type="hidden" name="{{ $fundDetail->fee_type }}_previous_receive" id="{{ $fundDetail->fee_type }}_previous_receive" value="{{ $fundDetail->prev_receive ?? 0 }}">
                                                        <td id="{{ $fundDetail->fee_type }}_discount_total">
                                                            {{ $fundDetail->prev_discount ?? 0 }}</td>
                                                            <input type="hidden" name="{{ $fundDetail->fee_type }}_previous_discount" id="{{ $fundDetail->fee_type }}_previous_discount" value="{{ $fundDetail->prev_discount ?? 0 }}">

                                                        <td>
                                                            <input type="text"
                                                                name="{{ $fundDetail->fee_type }}_fee_paid"
                                                                id="{{ $fundDetail->fee_type }}_fee_paid"
                                                                class="form-control"
                                                                data-fee-type = "{{ $fundDetail->fee_type }}"
                                                                placeholder="{{ ucfirst($fundDetail->fee_type) }} Fee Paid"
                                                                value="{{ $fundDetail->receive ?? 0 }}"
                                                                data-amount="{{ $fundDetail->receive ?? 0 }}" readonly>
                                                        </td>

                                                        <td>
                                                            <input type="text" name="{{ $fundDetail->fee_type }}_fee_discount"
                                                                id="{{ $fundDetail->fee_type }}_fee_discount" class="form-control"
                                                                placeholder="{{ ucfirst($fundDetail->fee_type) }} Fee Discount" value="{{ $fundDetail->discount ?? 0 }}" readonly>
                                                        </td>
                                                        <td>
                                                            <input type="text" name="{{ $fundDetail->fee_type }}_fee_due"
                                                                id="{{ $fundDetail->fee_type }}_fee_due" class="form-control"
                                                                placeholder="{{ $fundDetail->fee_type }} Fee Due" value="{{ $fundDetail->due ?? 0 }}" readonly>
                                                        </td>



                                                    </tr>
                                                @endforeach



                                            @endif
                                        </tbody>
                                    </table>

                                </div>


                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="total_amount">Total Amount</label>
                                        <input type="number" name="total_amount" id="total_amount"
                                            value="{{ old('total_amount', $data->total_amount ?? 0) }}" class="form-control total_amount"
                                            placeholder="Total Amount" readonly>
                                    </div>
                                    @error('total_amount')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="current_receive_amount">Receive Amount <span class="text-red">*</span></label>
                                        <input type="number" name="current_receive_amount" id="current_receive_amount" value="{{ old('current_receive_amount', $data->current_receive ?? 0) }}" class="form-control " placeholder="Current Receive Amount" required="" readonly="">
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="receive_amount">Total Receive Amount <span
                                                class="text-red">*</span></label>
                                        <input type="number" name="receive_amount" id="receive_amount"
                                            value="{{ old('receive_amount', $data->receive_amount ?? 0) }}"
                                            class="form-control @error('receive_amount') is-invalid @enderror"
                                            placeholder="Receive Amount" required readonly>
                                        @error('receive_amount')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="discount_amount">Total Discount Amount</label>
                                        <input type="number" name="discount_amount" id="discount_amount"
                                            value="{{ old('discount_amount', $data->discount_amount ?? 0) }}" class="form-control"
                                            placeholder="Discount Amount" readonly>
                                    </div>

                                    @error('discount_amount')
                                        <span class="text-danger" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="due_amount">Total Due Amount</label>
                                        <input type="number" name="due_amount" id="due_amount"
                                            value="{{ old('due_amount', $data->due_amount ?? 0) }}"
                                            class="form-control @error('due_amount') is-invalid @enderror"
                                            placeholder="Due Amount" readonly>
                                    </div>
                                </div>


                            </div>

                            <div class="col-md-12" id="newForm"></div>

                            <div class="row mt-30">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-success mr-2">Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>

    @push('js')
        <script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script>
            // $('#student_id').select2();
            // $('#month').select2({
            //     placeholder: 'Search and select month',
            //     ajax: {
            //         url: '{{ route('months.search') }}',
            //         dataType: 'json',
            //         delay: 250,
            //         data: function(params) {
            //             return {
            //                 q: params.term // user input
            //             };
            //         },
            //         processResults: function(data) {
            //             return {
            //                 results: data
            //             };
            //         },
            //         cache: true
            //     },
            //     width: '100%'
            // });
            $(function() {
                // $('#month').datepicker({
                //     changeMonth: true,
                //     changeYear: true,
                //     showButtonPanel: true,
                //     yearRange: "-10:+100",
                //     dateFormat: 'MM-yy',
                //     onClose: function(dateText, inst) {
                //         $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
                //         triggerAjaxCall();
                //     }
                // });


            });

            function triggerAjaxCall() {
                var student_id = $('#student_id').val();
                var month = $('#month').val();
                var class_id = $('#class_id').val();
                var session_id = $('#student_id').find(':selected').data('session_id');
                console.log(class_id, session_id, student_id, month);

                if (student_id && month && class_id && session_id) {
                    $.ajax({
                        url: "{{ route('student.payment') }}",
                        type: 'POST',
                        data: {
                            month: month,
                            student_id: student_id,
                            session_id: session_id,
                            class_id: class_id,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(data) {
                            console.log(data);
                            $('#newForm').html(data.html);
                            $('#payment_details').html(data.typeList);
                            $('#total_amount').val(data.totalAmount);
                            $('#due_amount').val(data.totalAmount);
                            $('#donarName').val(data.donarName);
                            $('#donar_id').val(data.donar_id);

                            var totalReceived = data.totalReceived || 0;
                            var totalDiscount = data.totalDiscount || 0;

                            $('#total_received_label').text('Total Received: ' + totalReceived);
                            $('#total_discount_label').text('Total Discount: ' + totalDiscount);

                            var initialDue = data.totalAmount - (totalReceived + totalDiscount);
                            $('#due_amount').val(initialDue);

                            $('#payment_info').show();
                            totalCalculate();
                        }
                    });
                }
            }

            $(document).ready(function() {
                $('#note_field').removeClass('col-sm-6').addClass('col-sm-12');
                $('#payment_info').hide();

                $('#student_id').on('change', function() {
                    console.log('student changed');
                    triggerAjaxCall();
                });

                $('#class_id').on('change', function() {
                    console.log('class changed');
                    triggerAjaxCall();
                });

                $(document).on('keyup', '#amount', function() {
                    updateAmounts();
                });

                $(document).on('keyup', '#discount', function() {
                    updateAmounts();
                });

                $(document).on('change', '#month', function() {
                    console.log('month changed');
                    triggerAjaxCall();
                });

                function updateAmounts() {
                    var receive = parseFloat($('#amount').val()) || 0;
                    var discount = parseFloat($('#discount').val()) || 0;
                    var totalAmount = parseFloat($('#total_amount').val()) || 0;
                    var totalReceived = parseFloat($('#total_received_label').text().replace('Total Received: ', '')) ||
                        0;
                    var totalDiscount = parseFloat($('#total_discount_label').text().replace('Total Discount: ', '')) ||
                        0;

                    var totalPaid = totalReceived || 0;
                    var currentDue = totalAmount - (totalPaid + totalDiscount);

                    if (receive > currentDue) {
                        alert('Received amount cannot be more than the due amount');
                        $('#amount').val('');
                        $('#due_amount').val(currentDue);
                        return;
                    }

                    var due = currentDue - receive - discount;

                    if (due < 0) {
                        alert('Received amount and Discount amount exceed the total amount.');
                        $('#due_amount').val(0);
                        $('#discount').val(0);
                    } else {
                        $('#due_amount').val(due);
                    }
                }

                @if (Session::has('success'))
                    toastr.options = {
                        "closeButton": true,
                        "progressBar": true,
                        "timeOut": 2000
                    };
                    toastr.success("{{ session('success') }}");
                @endif

                @if (Session::has('error'))
                    toastr.options = {
                        "closeButton": true,
                        "progressBar": true
                    };
                    toastr.error("{{ session('error') }}");
                @endif
            });

            $(document).on('change', '#class_id', function() {
                let class_id = $(this).val();
                let studentSelect = $('#student_id');
                studentSelect.empty().append('<option value="">Loading...</option>');

                if (class_id) {
                    $.ajax({
                        url: "{{ route('get.students.by.class') }}",
                        type: "POST",
                        data: {
                            _token: "{{ csrf_token() }}",
                            class_id: class_id
                        },
                        success: function(data) {
                            console.log("data re", data);
                            studentSelect.empty().append('<option value="">Select One</option>');
                            data.forEach(function(student) {
                                studentSelect.append('<option data-session_id="' + student
                                    .session_id + '" value="' + student.id + '">' + student
                                    .name + ' | ' + (student.register_no ?? '') + '</option>');
                            });
                        },
                        error: function() {
                            studentSelect.empty().append(
                                '<option value="">Error loading students</option>');
                        }
                    });
                } else {
                    studentSelect.empty().append('<option value="">Select One</option>');
                }
            });

            // academic fee
            $(document).on("keyup", "#academic_fee_paid, #academic_fee_discount, #academic_fee_due", function() {
                console.log("academic fee paid, discount, due");
                academicFeeCalculate();
            });

            function academicFeeCalculate() {
                let totalAmount = parseFloat($('#academic_amount_total').text()) || 0;
                  let receiveTotal = parseFloat($('#academic_receive_total').text()) || 0;
                let paid = parseFloat($('#academic_fee_paid').val()) || 0;
                let feeType = $('#academic_fee_paid').attr('data-fee-type');
                let discount = parseFloat($('#academic_fee_discount').val()) || 0;

                if (paid + receiveTotal > totalAmount) {
                    paid = totalAmount - receiveTotal;
                    $('#academic_fee_paid').val(paid);
                }

                if (paid + discount + receiveTotal > totalAmount) {
                    discount = totalAmount - paid - receiveTotal;
                    $('#academic_fee_discount').val(discount); // Fixed this line
                }

                let due = totalAmount - (paid + discount + receiveTotal);
                $('#academic_fee_due').val(due);

                checkAvailableAmount(feeType);

                totalCalculate();
            }

            // hostel fee
            $(document).on("keyup", "#hostel_fee_paid, #hostel_fee_discount, #hostel_fee_due", function() {
                console.log("hostel fee paid, discount, due");
                hostelFeeCalculate();
            });

            function hostelFeeCalculate() {
                let totalAmount = parseFloat($('#hostel_amount_total').text()) || 0;
                let paid = parseFloat($('#hostel_fee_paid').val()) || 0;
                let discount = parseFloat($('#hostel_fee_discount').val()) || 0;

                if (paid > totalAmount) {
                    paid = totalAmount;
                    $('#hostel_fee_paid').val(paid);
                }

                if (paid + discount > totalAmount) {
                    discount = totalAmount - paid;
                    $('#hostel_fee_discount').val(discount);
                }

                let due = totalAmount - (paid + discount);
                $('#hostel_fee_due').val(due);

                totalCalculate();
            }

            // onabashik fee
            $(document).on("keyup", "#onabashik_fee_paid, #onabashik_fee_discount, #onabashik_fee_due", function() {
                console.log("onabashik fee paid, discount, due");
                onabashikFeeCalculate();
            });

            function onabashikFeeCalculate() {
                let totalAmount = parseFloat($('#onabashik_amount_total').text()) || 0;
                let paid = parseFloat($('#onabashik_fee_paid').val()) || 0;
                let discount = parseFloat($('#onabashik_fee_discount').val()) || 0;

                if (paid > totalAmount) {
                    paid = totalAmount;
                    $('#onabashik_fee_paid').val(paid);
                }

                if (paid + discount > totalAmount) {
                    discount = totalAmount - paid;
                    $('#onabashik_fee_discount').val(discount); // Fixed this line
                }

                let due = totalAmount - (paid + discount);
                $('#onabashik_fee_due').val(due);

                totalCalculate();
            }

            // other fee
            $(document).on("keyup", "#other_fee_paid, #other_fee_discount, #other_fee_due", function() {
                console.log("other fee paid, discount, due");
                otherFeeCalculate();
            });

            function otherFeeCalculate() {
                let totalAmount = parseFloat($('#other_fee_paid').attr('data-amount')) || 0;
                let paid = parseFloat($('#other_fee_paid').val()) || 0;
                let discount = parseFloat($('#other_fee_discount').val()) || 0;
                console.log("other fee paid, discount, due", totalAmount, paid, discount);

                if (paid > totalAmount) {
                    paid = totalAmount;
                    $('#other_fee_paid').val(paid);
                }

                if (paid + discount > totalAmount) {
                    discount = totalAmount - paid;
                    $('#other_fee_discount').val(discount);
                }

                let due = totalAmount - (paid + discount);
                $('#other_fee_due').val(due);

                totalCalculate();
            }

            // special Fee
            $(document).on("keyup", "#special_fee_paid, #special_fee_discount, #special_fee_due", function() {
                console.log("special fee paid, discount, due");
                specialFeeCalculate();
            });

            function specialFeeCalculate() {
                let totalAmount = parseFloat($('#special_amount_total').text()) || 0;
                let paid = parseFloat($('#special_fee_paid').val()) || 0;
                let discount = parseFloat($('#special_fee_discount').val()) || 0;

                if (paid > totalAmount) {
                    paid = totalAmount;
                    $('#special_fee_paid').val(paid);
                }

                if (paid + discount > totalAmount) {
                    discount = totalAmount - paid;
                    $('#special_fee_discount').val(discount);
                }

                let due = totalAmount - (paid + discount);
                $('#special_fee_due').val(due);

                totalCalculate();
            }

            $(document).on("change",
                "input[name='rows[academic][enabled]'], input[name='rows[hostel][enabled]'], input[name='rows[onabashik][enabled]'], input[name='rows[other][enabled]'], input[name='rows[special][enabled]']",
                function() {
                    totalCalculate();
                });

            function checkAvailableAmount(key){
                let currentAmount = parseFloat($(`#${key}_fee_paid`).val()) || 0;
                let currentDiscount = parseFloat($(`#${key}_fee_discount`).val()) || 0;
                let currentDue = parseFloat($(`#${key}_fee_due`).val()) || 0;
                let totalAmount = parseFloat($(`#${key}_amount_total`).text()) || 0;
                let feeType =  key;
                let month = $('#month').val();
                let studentId = $('#student_id').val();

                $.ajax({
                    url: "{{ route('payment.check.available.balance') }}",
                    type: 'POST',
                    data: {
                        currentAmount: currentAmount,
                        currentDiscount: currentDiscount,
                        currentDue: currentDue,
                        feeType: feeType,
                        month: month,
                        studentId: studentId,
                        totalAmount: totalAmount,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(data) {
                        console.log(data);
                        // $(`#${key}_fee_paid`).val(data.paid);
                        // $(`#${key}_fee_discount`).val(data.discount);
                        // $(`#${key}_fee_due`).val(data.due);
                    }    
                });
                
            }

            function totalCalculate() {
                let academicFeePaid = parseFloat($('#academic_fee_paid').val()) || 0;
                let academicFeeDiscount = parseFloat($('#academic_fee_discount').val()) || 0;
                let academicPreviouseReceive = parseFloat($('#academic_receive_total').text()) || 0;
                let academicPreviouseDiscount = parseFloat($('#academic_discount_total').text()) || 0;

                let hostelFeePaid = parseFloat($('#hostel_fee_paid').val()) || 0;
                let hostelFeeDiscount = parseFloat($('#hostel_fee_discount').val()) || 0;
                let hostelPreviouseReceive = parseFloat($('#hostel_receive_total').text()) || 0;
                let hostelPreviouseDiscount = parseFloat($('#hostel_discount_total').text()) || 0;

                let onabashikFeePaid = parseFloat($('#onabashik_fee_paid').val()) || 0;
                let onabashikFeeDiscount = parseFloat($('#onabashik_fee_discount').val()) || 0;
                let onabashikPreviouseReceive = parseFloat($('#onabashik_receive_total').text()) || 0;
                let onabashikPreviouseDiscount = parseFloat($('#onabashik_discount_total').text()) || 0;


                let otherFeePaid = parseFloat($('#other_fee_paid').val()) || 0;
                let otherFeeDiscount = parseFloat($('#other_fee_discount').val()) || 0;
                let otherPreviouseReceive = parseFloat($('#other_receive_total').text()) || 0;
                let otherPreviouseDiscount = parseFloat($('#other_discount_total').text()) || 0;

                let specialFeePaid = parseFloat($('#special_fee_paid').val()) || 0;
                let specialFeeDiscount = parseFloat($('#special_fee_discount').val()) || 0;
                let specialPreviouseReceive = parseFloat($('#special_receive_total').text()) || 0;
                let specialPreviouseDiscount = parseFloat($('#special_discount_total').text()) || 0;

                //academic checked
                let enableAcademic = $('input[name="rows[academic][enabled]"]').is(':checked');
                let enableHostel = $('input[name="rows[hostel][enabled]"]').is(':checked');
                let enableOnabashik = $('input[name="rows[onabashik][enabled]"]').is(':checked');
                let enableOther = $('input[name="rows[other][enabled]"]').is(':checked');
                let enableSpecial = $('input[name="rows[special][enabled]"]').is(':checked');

                let total = parseFloat($('#total_amount').val()) || 0;

                $('.total_amount').val(total);

                let totalReceive = (enableAcademic ? academicFeePaid : 0) +
                    (enableHostel ? hostelFeePaid : 0) +
                    (enableOnabashik ? onabashikFeePaid : 0) +
                    (enableOther ? otherFeePaid : 0) +
                    (otherPreviouseReceive ?? 0) +
                    (academicPreviouseReceive ?? 0) +
                    (hostelPreviouseReceive ?? 0) +
                    (onabashikPreviouseReceive ?? 0) +
                    (specialPreviouseReceive ?? 0) +
                    (enableSpecial ? specialFeePaid : 0);
                $('#receive_amount').val(totalReceive);

                  let currentReceive = (enableAcademic ? academicFeePaid : 0) +
                    (enableHostel ? hostelFeePaid : 0) +
                    (enableOnabashik ? onabashikFeePaid : 0) +
                    (enableOther ? otherFeePaid : 0) +
                    (enableSpecial ? specialFeePaid : 0);

                $('#current_receive_amount').val(currentReceive);

                let totalDiscount = (enableAcademic ? academicFeeDiscount : 0) +
                    (enableHostel ? hostelFeeDiscount : 0) +
                    (enableOnabashik ? onabashikFeeDiscount : 0) +
                    (enableOther ? otherFeeDiscount : 0) +
                    (otherPreviouseDiscount ?? 0) +
                    (academicPreviouseDiscount ?? 0) +
                    (hostelPreviouseDiscount ?? 0) +
                    (onabashikPreviouseDiscount ?? 0) +
                    (specialPreviouseDiscount ?? 0) +
                    (enableSpecial ? specialFeeDiscount : 0);
                $('#discount_amount').val(totalDiscount);

                let totalDue = total - (totalReceive + totalDiscount);
                console.log("total due", totalDue,
                    "total", total,
                    "total receive", totalReceive,
                    "total discount", totalDiscount,
                    "enable academic", enableAcademic,
                    "enable hostel", enableHostel,
                    "enable onabashik", enableOnabashik,
                    "enable other", enableOther,
                    "enable special", enableSpecial
                );
                $('#due_amount').val(totalDue);

                enableAcademic ? $("select[id='fund_id_academic']").prop('required', true) : $("select[id='fund_id_academic']")
                    .prop('required', false);
                enableHostel ? $("select[id='fund_id_hostel']").prop('required', true) : $("select[id='fund_id_hostel']").prop(
                    'required', false);
                enableOnabashik ? $("select[id='fund_id_onabashik']").prop('required', true) : $(
                    "select[id='fund_id_onabashik']").prop('required', false);
                enableOther ? $("select[id='fund_id_other']").prop('required', true) : $("select[id='fund_id_other']").prop(
                    'required', false);
                enableSpecial ? $("select[id='fund_id_special']").prop('required', true) : $("select[id='fund_id_special']")
                    .prop('required', false);
            }
        </script>
    @endpush
@endsection
