@extends('dashboard.master')
@section('title', 'Money Receipt List')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Money Receipt List</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Create Button" href="{{ route('payment.create') }}" type="button"
                            class="btn btn-sm btn-success">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Studen/Reg</th>
                                    <th>Class</th>
                                    <th>Month</th>
                                    <th>Paid</th>
                                    <th>Due</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            $(document).ready(function() {
                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    responsive: false,
                    scrollX: true,
                    autoWidth: false,
                    serverSide: true,
                    scroller: {
                        loadingIndicator: false
                    },
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "{{ route('payment.list') }}",
                        type: "get"
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            searchable: false
                        },
                        {
                            data: 'student',
                            name: 'student'
                        },
                        {
                            data: 'department',
                            name: 'department'
                        },
                        {
                            data: 'date',
                            name: 'date'
                        },
                        {
                            data: 'amount',
                            name: 'amount'
                        },
                        {
                            data: 'due',
                            name: 'due'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],
                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Money Received List',
                            header: true,
                            footer: true,
                        },


                        {
                            extend: 'excel',
                            className: 'btn-sm btn-success',
                            title: 'Payment List',
                            header: true,
                            footer: true,
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5],
                                stripHtml: true
                            }
                        },

                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Money Received List',
                            pageSize: 'A2',
                            header: true,
                            footer: true,
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility',
                            title: 'Column Visibility',
                            columns: ':not(:first-child)'
                        }
                    ],
                });
            });

            //  toastr.options.timeOut = 300;
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
