@extends('dashboard.master')
@section('title', 'Money Receipt List')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .select2-container {
            width: 100% !important;
        }

        .select2-container--default .select2-selection--single {
            height: 38px;
            border: 1px solid #ced4da;
            border-radius: .25rem;
            display: flex;
            align-items: center;
            padding-left: .5rem;
            background-color: #fff;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 38px;
            padding-left: 0;
            color: #495057;
        }

        .select2-container--default .select2-selection--single .select2-selection__placeholder {
            color: #6c757d;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: 38px;
            right: .5rem;
        }

        .select2-container--default .select2-selection--single:focus,
        .select2-container--default.select2-container--focus .select2-selection--single {
            border-color: #86b7fe;
            outline: 0;
            box-shadow: 0 0 0 .25rem rgba(13, 110, 253, .25);
        }

        .select2-container--default .select2-dropdown {
            border: 1px solid #ced4da;
            border-radius: .25rem;
            overflow: hidden;
        }

        .select2-container--default .select2-results__option--highlighted[aria-selected] {
            background-color: #0d6efd;
        }

        .select2-search--dropdown .select2-search__field {
            border: 1px solid #ced4da;
            border-radius: .25rem;
            padding: .375rem .75rem;
        }

        .select2-container .select2-dropdown {
            z-index: 1055;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon"><i class="nav-icon fas fa-mosque"></i></div>
                        <span><b>Money Receipt List</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a href="{{ route('payment.create') }}" class="btn btn-sm btn-success">
                            <i class="fas fa-plus mr-1"></i> Create
                        </a>
                        <a href="{{ route('payment.multi.month.create') }}" class="btn btn-sm btn-success">
                            <i class="fas fa-plus mr-1"></i> Create Multiple
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="row mb-3 px-3 pt-3">
                        <div class="col-md-4">
                            <label for="month">Select Month</label>
                            <select id="month" class="form-control"></select>
                        </div>
                        <div class="col-md-4">
                            <label for="class_id">Select Class</label>
                            <select id="class_id" class="form-control">
                                <option value="">All Classes</option>
                                @foreach ($classes as $class)
                                    <option value="{{ $class->id }}">{{ $class->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Studen/Reg</th>
                                    <th>Class</th>
                                    <th>Month</th>
                                    <th>Total Amount</th>
                                    <th>Total Receive</th>
                                    <th>Last Receive</th> {{-- NEW --}}
                                    <th>Total Discount</th>
                                    <th>Total Due</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>

                </div>
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

    <script>
        // Month select2
        $('#month').select2({
            placeholder: 'Search and select month',
            allowClear: true,
            width: '100%',
            dropdownParent: $('#month').closest('.col-md-4'),
            ajax: {
                url: '{{ route('months.search') }}',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        q: params.term
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });

        $(document).ready(function() {
            var dTable = $('#data_table').DataTable({
                order: [],
                processing: true,
                serverSide: true,
                responsive: false,
                scrollX: true,
                autoWidth: false,
                language: {
                    processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                },
                pagingType: "full_numbers",
                ajax: {
                    url: "{{ route('payment.list.new') }}",
                    type: "get",
                    data: function(d) {
                        d.month = $('#month').val();
                        d.class_id = $('#class_id').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        searchable: false
                    },
                    {
                        data: 'student',
                        name: 'student'
                    },
                    {
                        data: 'department',
                        name: 'department'
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'total_amount',
                        name: 'total_amount'
                    },
                    {
                        data: 'receive_amount',
                        name: 'receive_amount'
                    },
                    {
                        data: 'last_receive_date',
                        name: 'last_receive_date'
                    }, // NEW
                    {
                        data: 'discount_amount',
                        name: 'discount_amount'
                    },
                    {
                        data: 'due_amount',
                        name: 'due_amount'
                    },
                    {
                        data: 'action',
                        searchable: false,
                        orderable: false
                    }
                ],
                dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                buttons: [{
                        extend: 'copy',
                        className: 'btn-sm btn-info',
                        title: 'Money Received List',
                        header: true,
                        footer: true
                    },
                    {
                        extend: 'excel',
                        className: 'btn-sm btn-success',
                        title: 'Payment List',
                        header: true,
                        footer: true,
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6, 7, 8],
                            stripHtml: true
                        }
                    }, // exclude action (index 9)
                    {
                        extend: 'print',
                        className: 'btn-sm btn-danger',
                        title: 'Money Received List',
                        pageSize: 'A2',
                        header: true,
                        footer: true,
                        orientation: 'landscape',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        extend: 'colvis',
                        className: 'btn-sm btn-warning',
                        text: 'Column Visibility',
                        title: 'Column Visibility',
                        columns: ':not(:first-child)'
                    }
                ],
            });

            $('#month, #class_id').on('change', function() {
                dTable.ajax.reload();
            });
        });

        // Toastr flashes
        @if (Session::has('success'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "timeOut": 2000
            };
            toastr.success("{{ session('success') }}");
        @endif
        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            };
            toastr.error("{{ session('error') }}");
        @endif

        // Delete row
        $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
            e.preventDefault();
            const url = $(this).data('remote');
            swal({
                title: `Are you sure?`,
                text: "Want to delete this record?",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        url: url,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            submit: true,
                            _method: 'delete',
                            _token: "{{ csrf_token() }}"
                        }
                    }).always(function(data) {
                        $('#data_table').DataTable().ajax.reload();
                        if (data.success === true) {
                            toastr.success(data.message, {
                                positionClass: 'toast-bottom-full-width'
                            });
                        } else {
                            toastr.error(data.message, {
                                positionClass: 'toast-bottom-full-width'
                            });
                        }
                    });
                }
            });
        });
    </script>
@endpush
