@extends('dashboard.master')
@section('title', 'Create Sponsor Payment Receive')

@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
    .ui-datepicker-calendar {
        display: none;
    }
    #student_id {
        text-align: center;
    }
    .select2-container .select2-selection--single {
        height: 38px;
    }
</style>
@endpush

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Create Sponsor Payment Receive</b></span>
                </div>
                <div class="page-title-actions">
                    <a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">

                    @if(session('error'))
                        <div class="alert alert-danger mt-2">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form enctype="multipart/form-data" action="{{ route('sponsor.amount.take.store') }}" method="POST">
                        @csrf
                        <div class="row">

                            <div class="col-sm-12" id="payment_info" style="display: none;">
                                <label id="total_received_label"></label>
                                <br>
                                <label id="total_discount_label"></label>
                                <br>
                            </div>

                              <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="month">Month<span class="text-red">*</span></label>
                                        <select name="month" id="month"
                                            class="form-control select2 @error('month') is-invalid @enderror" required>
                                            <option value="">Choose month</option>

                                        </select>
                                        @error('month')
                                            <span class="text-danger" role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="donar_id">Donar</label>
                                    <select name="donar_id" id="donar_id" class=" form-control @error('donar_id') is-invalid @enderror">
                                        <option value="">Select One</option>
                                        @foreach ($donars as $key => $donar)
                                            <option value="{{ $donar->id }}">{{ $donar->name }} | {{ $donar->phone }}</option>
                                        @endforeach
                                    </select>
                                    @error('donar_id')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Student<span class="text-red">*</span></label>
                                    <select name="student_id" id="student_id" class="form-control">
                                        <option value="">Select One</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Total Amount</label>
                                    <input type="number" name="total_amount" id="total_amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" readonly>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Receive Amount <span class="text-red">*</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="amount" required>
                                    @error('amount')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Discount Amount</label>
                                    <input type="number" name="discount" id="discount" value="{{ old('discount') }}" class="form-control" placeholder="amount" >
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Due Amount</label>
                                    <input type="number" name="due_amount" id="due_amount" value="{{ old('due_amount') }}" class="form-control @error('due_amount') is-invalid @enderror" placeholder="amount" readonly>
                                </div>
                            </div>

                            <div class="col-sm-12" id="note_field">
                                <div class="form-group">
                                    <label for="note">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12" id="newForm"></div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
  $('#student_id').select2();
     $('#month').select2({
                placeholder: 'Search and select month',
                ajax: {
                    url: '{{ route('months.search') }}',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term // user input
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data
                        };
                    },
                    cache: true
                },
                width: '100%'
            });
$(function() {
    $('#month').datepicker({
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        yearRange: "-10:+100",
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) {
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            // Trigger AJAX call when date is selected
            triggerAjaxCall();
        }
    });
});

function triggerAjaxCall() {
    var student_id = $('#student_id').val();
    var month = $('#month').val();
    var class_id = $('#student_id').find(':selected').data('class_id');
    var session_id = $('#student_id').find(':selected').data('session_id');
    var donar_id = $('#donar_id').val();

    if (student_id) {
        $.ajax({
                url: "{{ route('student.payment') }}",
                type: 'POST',
                data: {
                    month: month,
                    donar_id: donar_id,
                    student_id: student_id,
                    class_id: class_id,
                    session_id: session_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    console.log("student payment data", data)
                    $('#newForm').html(data.typeList);
                    $('#total_amount').val(data.totalAmount);
                    $('#due_amount').val(data.totalAmount);

                    var totalReceived = data.totalReceived || 0;
                    var totalDiscount = data.totalDiscount || 0;

                    $('#total_received_label').text('Total Received: ' + totalReceived);
                    $('#total_discount_label').text('Total Discount: ' + totalDiscount);

                    var initialDue = data.totalAmount - (totalReceived + totalDiscount);
                    $('#due_amount').val(initialDue);

                    if (data.donarName) {
                        $('#sponsor_name_field').show();
                        $('#note_field').removeClass('col-sm-12').addClass('col-sm-6');
                    } else {
                        $('#sponsor_name_field').hide();
                        $('#note_field').removeClass('col-sm-6').addClass('col-sm-12');
                    }

                    $('#payment_info').show();
                }
            });
    }
}

$(document).ready(function() {
    $('#donar_id').on('change', function() {
        var donar_id = $(this).val();

        if (donar_id) {
            $.ajax({
                url: "{{ route('sponsor.student') }}",
                type: 'POST',
                data: {
                    donar_id: donar_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    $('#student_id').empty().append('<option value="">Select One</option>');
                  $.each(data, function(index, student) {
                        let monthlyDis = student.student.monthly_dis ? ' | ' + student.student.monthly_dis + ' TK' : '';
                        $('#student_id').append(
                            '<option value="' + student.student_id + '" ' +
                            'data-class_id="' + student.student.class_id + '" ' +
                            'data-session_id="' + student.student.session_id + '">' +
                            student.student.name + ' | ' +
                            student.student.register_no + ' | ' +
                            student.student.roll_no +
                            monthlyDis +
                            '</option>'
                        );
                    });

                    $('#student_id').prop('disabled', false);
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching students:", error);
                }
            });
        } else {
            $('#student_id').empty().append('<option value="">Select One</option>').prop('disabled', true);
        }
    });
});

$(document).ready(function() {
    $('#note_field').removeClass('col-sm-6').addClass('col-sm-12');
    $('#payment_info').hide();
    
    $('#student_id').on('change', function() {
        triggerAjaxCall();
    });

    $(document).on('keyup', '#amount', function() {
        updateAmounts();
    });

    $(document).on('keyup', '#discount', function() {
        updateAmounts();
    });

    function updateAmounts() {
        var receive = parseFloat($('#amount').val()) || 0;
        var discount = parseFloat($('#discount').val()) || 0;
        var totalAmount = parseFloat($('#total_amount').val()) || 0;
        var totalReceived = parseFloat($('#total_received_label').text().replace('Total Received: ', '')) || 0;
        var totalDiscount = parseFloat($('#total_discount_label').text().replace('Total Discount: ', '')) || 0;

        var totalPaid = totalReceived || 0;
        var currentDue = totalAmount - (totalPaid + totalDiscount);

        if (receive > currentDue) {
            alert('Received amount cannot be more than the due amount');
            $('#amount').val('');
            $('#due_amount').val(currentDue);
            return;
        }

        var due = currentDue - receive - discount;

        if (due < 0) {
            alert('Received amount and Discount amount exceed the total amount.');
            $('#due_amount').val(0);
            $('#discount').val(0);
        } else {
            $('#due_amount').val(due);
        }
    }

    @if(Session::has('success'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "timeOut": 2000
        };
        toastr.success("{{ session('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.options = {
            "closeButton": true,
            "progressBar": true
        };
        toastr.error("{{ session('error') }}");
    @endif
});
</script>
@endpush
@endsection
