@extends('dashboard.master')

@section('title', 'Result Create')

@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <style>
        .select2-container--default .select2-selection--single {
            height: calc(2.25rem + 2px);
            line-height: calc(2.25rem + 2px);
        }

        .select2-container--default .select2-selection__rendered {
            padding-top: 0.375rem;
            padding-bottom: 0.375rem;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">

                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('success') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('error'))
                    @dd(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif

                @if (session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        {{ session('warning') }}
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                @endif
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>

                        <span><b>Result Create By Subject</b></span>
                    </div>



                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <form class="forms-sample add-class" enctype="multipart/form-data"
                        action="{{ route('result.store.subject') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Exam <span class="text-danger">*</span></label>
                                        <select name="exam_id" id="exam_id" class="form-control">
                                            <option value="">Select One</option>
                                            @foreach ($exams as $exam)
                                                <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Session <span class="text-danger">*</span></label>
                                        <select name="session_id" id="session_id" class="form-control">
                                            <option value="">Select Session</option>
                                            @foreach ($sessions as $item)
                                                <option value="{{ $item->id }}">{{ $item->name ?? '' }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Class <span class="text-danger">*</span></label>
                                        <select name="class_id" id="class_id" class="form-control">
                                            <option value="">Select Class</option>
                                            @foreach ($class as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>



                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Subject <span class="text-danger">*</span></label>
                                        <select name="subject_id" id="subject_id" class="form-control select2">
                                            <option value="">Select One</option>
                                        </select>
                                    </div>
                                </div>

                            </div>

                            <hr>
                            <div class="table-responsive hideClass">
                                <table class="table table-bordered table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Student</th>
                                            <th>Exam Marks</th>
                                            <th>Marks</th>
                                        </tr>
                                    </thead>
                                    <tbody id="subject_data"></tbody>
                                </table>
                            </div>

                            <div class="row mt-3 hideClass">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-primary">Save</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="{{ asset('backend/plugins/select2/js/select2.full.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
        integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.hideClass').hide();
            $('#student_id').select2();



            $('#class_id, #exam_id, #session_id').on('change', function() {
                $('#subject_id').empty().append('<option value="">Select Subject</option>');
                $('.hideClass').hide();

                var class_id = $('#class_id').val();
                var exam_id = $('#exam_id').val();
                var session_id = $('#session_id').val();
                var _token = $('meta[name="csrf-token"]').attr('content');

                if (class_id && exam_id && session_id) {
                    $.ajax({
                        url: "/get-subjects-by-class/" + class_id,
                        type: "GET",
                        success: function(response) {
                            console.log("response ", response);
                            if (response.length > 0) {
                                $.each(response, function(index, item) {
                                    if (item) {
                                        $('#subject_id').append(
                                            '<option value="' + item.id + '">' +
                                            item.name ?? 'N/A' + '</option>'
                                        );
                                    }
                                });
                            } else {
                                alert('No Subject Assign for This Class.');
                            }
                        },
                        error: function() {
                            alert('Failed to fetch Subject.');
                        }
                    });
                }
            });



            $('#subject_id').on('change', function() {

                var _token = $('meta[name="csrf-token"]').attr('content');
                var class_id = $('#class_id').val();
                var session_id = $('#session_id').val();
                var subject_id = $(this).val();
                var exam_id = $('#exam_id').val();

                $.ajax({
                    url: "{{ route('student.by-subject') }}",
                    type: "POST",
                    data: {
                        exam_id: exam_id,
                        session_id: session_id,
                        class_id: class_id,
                        subject_id: subject_id,
                        _token: _token,
                    },
                    success: function(response) {
                        console.log(response, 'response student', response?.length);
                        if (response?.length > 0) {
                            console.log("length zero theke besi. ", response);
                            var students = response;
                            var html = '';
                            for (var i = 0; i < students.length; i++) {
                                var student = students[i];
                                console.log("dur hala",student,student?.register_no);
                                html += '<tr>';
                                html += '<td>' + (i + 1) + '</td>';
                                html += '<td>' + student?.name +  ' || ' + student?.roll_no  + ' || ' + student?.register_no  + '</td>';
                                html += '<input type="hidden" name="student_id[]" value="' +
                                    student?.id + '">';
                                html += `<td id="subjectMark" data-key="${i}">${student?.exam_mark ?? 'N/A'}</td>`;
                                    html += `
                                        <td>
                                         <input type="number" name="mark[]"
                                                 class="form-control"
                                                 value="${student?.mark !== null ? student.mark : ''}"
                                                 ${student?.mark !== null ? 'readonly' : ''}
                                                 required>
                                     </td>
                                    `;
                                html += '</tr>';
                            }
                            $('#subject_data').html(html);
                            // alert('Result already exists for this student.');
                            // $('.add-class')[0].reset();
                            // location.reload();
                            $('.hideClass').show();
                        } else {
                            alert('No student found for this subject.');
                        }
                    },
                    error: function() {
                        alert('Error checking existing result.');
                    }
                });
            });
        });


        $(document).on('input', 'input[name="mark[]"]', function() {
            var $input = $(this);
            var key = $input.closest('tr').find('#subjectMark').data('key');
            var maxMark = parseFloat($('#subjectMark[data-key="' + key + '"]').text());

            var inputVal = parseFloat($input.val());
            if (inputVal > maxMark) {
                $input.val(maxMark);
                alert('Mark cannot exceed ' + maxMark);
            }
        });


        @if (Session::has('success'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "timeOut": 1000
            };
            toastr.success("{{ session('success') }}");
        @endif

        @if (Session::has('error'))
            toastr.options = {
                "closeButton": true,
                "progressBar": true
            };
            toastr.error("{{ session('error') }}");
        @endif
    </script>
@endpush
