@extends('dashboard.master')
@section('title', 'Result Edit')

@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
    <style>
        .select2-container--default .select2-selection--single {
            height: calc(2.25rem + 2px);
            line-height: calc(2.25rem + 2px);
        }

        .select2-container--default .select2-selection__rendered {
            padding-top: 0.375rem;
            padding-bottom: 0.375rem;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Result Edit</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <form class="forms-sample add-class" enctype="multipart/form-data"
                        action="{{ route('result.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Exam <span class="text-danger">*</span></label>
                                        <select name="exam_id" id="exam_id" class="form-control">
                                            <option value="">Select One</option>
                                            @foreach ($exams as $exam)
                                                <option value="{{ $exam->id }}" @selected($exam->id == $data->exam_id)>
                                                    {{ $exam->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Class <span class="text-danger">*</span></label>
                                        <select name="class_id" id="class_id" class="form-control">
                                            <option value="">Select Class</option>
                                            @foreach ($class as $item)
                                                <option value="{{ $item->id }}" @selected($item->id == $data->class_id)>
                                                    {{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Session <span class="text-danger">*</span></label>
                                        <select name="session_id" id="session_id" class="form-control">
                                            <option value="">Select Session</option>
                                            @foreach ($sessions as $session)
                                                <option value="{{ $session->id }}" @selected($session->id == $data->session_id)>
                                                    {{ $session->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Student <span class="text-danger">*</span></label>
                                        <select name="student_id" id="student_id" class="form-control select2">
                                            @foreach ($students as $item)
                                                <option value="{{ $item->student_id }}"
                                                    @if ($item->student_id == $data->student_id) selected @endif>
                                                    {{ $item->students->name ?? '' }} |
                                                    {{ $item->students->reister_no ?? '' }} |
                                                    {{ $item->students->roll_no ?? '' }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <hr>
                            <div class="table-responsive hideClass">
                                <table class="table table-bordered table-striped table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Subject</th>
                                            <th>Subject Marks</th>
                                            <th>Marks</th>
                                        </tr>
                                    </thead>
                                    <tbody id="student_data">
                                        {{-- @dd($results); --}}
                                        @foreach ($results as $result)
                                            @php
                                                $subjectId = $result->subject_id;
                                                $examMark = $examMarks[$subjectId] ?? 100; // fallback value
                                            @endphp
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>
                                                    {{ $result->subjects->name }}
                                                    <input type="hidden" name="subject_id[]"
                                                        value="{{ $result->subject_id }}">
                                                </td>
                                                <td id="subjectMark" data-key="{{ $loop->index }}">{{ $examMark ?? 100 }}</td>
                                                <td>
                                                    <input type="text" class="form-control" name="mark[]"
                                                        value="{{ $result->mark }}">
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <div class="row mt-3 hideClass">
                                <div class="col-sm-12">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script src="{{ asset('backend/plugins/select2/js/select2.full.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.hideClass').show(); // Keep subjects visible on edit
            $('#student_id').select2();

            $('#class_id, #exam_id, #session_id').on('change', function() {
                $('#student_id').empty().append('<option value="">Select Student</option>');
                $('.hideClass').hide();

                let class_id = $('#class_id').val();
                let exam_id = $('#exam_id').val();
                let session_id = $('#session_id').val();
                let _token = $('meta[name="csrf-token"]').attr('content');

                if (class_id && exam_id && session_id) {
                    $.ajax({
                        url: "{{ route('admit.wise.student') }}",
                        type: "POST",
                        data: {
                            class_id: class_id,
                            exam_id: exam_id,
                            session_id: session_id,
                            _token: _token,
                            editing: true, // Indicating it's edit mode
                        },
                        success: function(response) {
                            if (response.length > 0) {
                                $.each(response, function(index, item) {
                                    if (item.students) {
                                        $('#student_id').append(
                                            `<option value="${item.students.id}">
                                            ${item.students.name} || ${item.students.register_no} || ${item.students.roll_no}
                                        </option>`
                                        );
                                    }
                                });
                            } else {
                                alert('No students with Admit Card found.');
                            }
                        },
                        error: function() {
                            alert('Failed to fetch students.');
                        }
                    });
                }
            });

            $('#student_id').on('change', function() {
                let _token = $('meta[name="csrf-token"]').attr('content');
                let class_id = $('#class_id').val();
                let session_id = $('#session_id').val();
                let student_id = $(this).val();
                let exam_id = $('#exam_id').val();
                let editing_student_id = "{{ $data->student_id }}"; // Store the student ID being edited

                if (!student_id) return; // If no student selected, do nothing

                $.ajax({
                    url: "{{ route('result.wise.student') }}",
                    type: "POST",
                    data: {
                        exam_id: exam_id,
                        session_id: session_id,
                        class_id: class_id,
                        student_id: student_id,
                        _token: _token,
                    },
                    success: function(response) {
                        if (response && student_id !== editing_student_id) {
                            // Show alert only for students that are not being edited
                            alert('Result already exists for this student.');
                            $('.add-class')[0].reset();
                            location.reload();
                            $('.hideClass').hide();
                        } else {
                            // If result does not exist for the student being edited, fetch subjects
                            $.ajax({
                                url: "{{ route('class.wise.subject') }}",
                                type: "POST",
                                data: {
                                    class_id: class_id,
                                    _token: _token,
                                },
                                success: function(res) {
                                    if (res.html && res.html.trim() !== "") {
                                        $('#student_data').html(res.html);
                                        $('.hideClass').show();
                                    } else {
                                        alert('No subjects found for this class.');
                                    }
                                },
                                error: function() {
                                    alert('Error fetching subjects.');
                                }
                            });
                        }
                    },
                    error: function() {
                        alert('Error checking existing result.');
                    }
                });
            });
        });

        $(document).on('input', 'input[name="mark[]"]', function () {
        var $input = $(this);
        var key = $input.closest('tr').find('#subjectMark').data('key');
        var maxMark = parseFloat($('#subjectMark[data-key="' + key + '"]').text());

        var inputVal = parseFloat($input.val());
        if (inputVal > maxMark) {
            $input.val(maxMark);
            alert('Mark cannot exceed ' + maxMark);
        }
    });
    </script>
@endpush
