<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Academic Marksheet</title>
  <style>
    .marksheet-container {
      max-width: 800px;
      margin: 0 auto;
      border: 1px solid #ccc;
      padding: 20px;
      background-color: #fff;
      font-family: 'Arial', sans-serif;
      color: #000;
      text-align: center;
    }

    .header {
      margin-bottom: 20px;
    }

    .header h2 {
      margin: 0;
      font-size: 24px;
    }

    .header p {
      margin: 5px 0;
      font-size: 16px;
    }

    .header h3 {
      font-size: 20px;
      margin: 10px 0;
    }

    .student-info {
      text-align: left;
      margin-bottom: 20px;
    }

    .student-info p {
      margin: 5px 0;
      font-size: 16px;
    }

    .marks-details table {
      width: 100%;
      border-collapse: collapse;
      margin: 0 auto;
    }

    .marks-details th,
    .marks-details td {
      border: 1px solid #000;
      padding: 10px;
      font-size: 16px;
      text-align: center;
    }

    .marks-details th {
      background-color: #f5f5f5;
      font-weight: bold;
    }
  </style>
</head>
<body>
  <div class="marksheet-container">
    <div class="header">
      <h2>{{ $setting->name ?? '' }}</h2>
      <p>{{ $setting->address ?? '' }}</p>
      <h3>{{ $data->exam->name ?? '' }}</h3>
      <p >একাডেমিক মার্কশিট</p>
    </div>
    <div class="student-info">
      <p><strong>জামাত:</strong> {{ $data->stuclass->name ?? '' }}</p>
      <p><strong>রোল নম্বর:</strong> {{ $data->students->roll_no ?? '' }}, <strong>জন্ম তারিখ:</strong> {{ $data->students->birth_date ?? '' }}</p>
      <p><strong>নাম:</strong> {{ $data->students->name ?? '' }}</p>
      <p><strong>পিতা:</strong> {{ $data->students->father_name ?? '' }}</p>
    </div>
    <div class="marks-details">
      <table>
        <thead>
          <tr>
            <th>ক্র.নং</th>
            <th>বিষয়</th>
            <th>প্রাপ্ত নম্বর</th>
          </tr>
        </thead>
        <tbody>
            @foreach ($results as $key => $result)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $result->subjects->name ?? '' }}</td>
                <td>{{ $result->mark ?? '' }}</td>
            </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="2" style="text-align: left"><strong>Total</strong></td>
                <td><strong>{{ $totalMark ?? '' }}</strong></td>
            </tr>

        </tfoot>
      </table>
    </div>
  </div>
</body>
<script type="text/javascript">
    // localStorage.clear();
    // function auto_print() {
    //     window.print()
    // }
    // setTimeout(auto_print, 1000);
</script>
</html>
