@extends('dashboard.master')
@section('title', 'Due Edit')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Due Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('due.taken.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ \Carbon\Carbon::parse($data->date)->format('Y-m-d') }}" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Shop<span class="text-red">*</span></label>
                                    <select name="shop_id" id="shop_id" class="form-control" required>
                                        <option value="">Select One</option>
                                        @foreach ($shops as $shop)
                                            <option value="{{ $shop->id }}" @if($shop->id == $data->shop->id) selected @endif>{{ $shop->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Due Taken By<span class="text-red">*</span></label>
                                    <input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control" placeholder="enter name" required>
                                 </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Due Amount<span class="text-red">*</span></label>
                                    <input type="number" name="amount" id="amount" value="{{ $data->amount }}" class="form-control" placeholder="enter due amount" required>
                                 </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Purpose</label>
                                    <textarea name="purpose" id="purpose" cols="2" rows="2" class="form-control" placeholder="write purpose ">{{ $data->purpose }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control" placeholder="write note here ...">{{ $data->note }}</textarea>
                                </div>
                            </div>

                        </div>

						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd',
        onSelect: function (dateText) {
            alert("Data will be updated to this date: " + dateText);
        }
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });
});

</script>
@endpush
@endsection
