@extends('dashboard.master')
@section('title', 'Loan Given Edit')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Loan Given Edit</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('loan.given.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ \Carbon\Carbon::parse($data->date)->format('Y-m-d') }}" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Taken By<span class="text-red">*</span></label>
                                    <input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control" placeholder="enter name" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Phone</label>
                                    <input type="text" name="phone" value="{{ $data->phone }}" id="phone" class="form-control" placeholder="enter phone">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}" @if($data->fund_id == $fund->id) selected @endif>{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Amount<span class="text-red">*</span> <span >(Available: <b id="availableAmount"></b>)</span></label>
                                    <input type="number" name="amount" value="{{ $data->amount }}" id="amount" class="form-control" placeholder="enter amount" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Purpose</label>
                                    <textarea name="purpose" id="purpose" cols="2" rows="2" class="form-control" placeholder="write purpose ">{{ $data->purpose }}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control" placeholder="write note here ...">{{ $data->note }}</textarea>
                                </div>
                            </div>

                        </div>

						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(function () {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd',
        onSelect: function (dateText) {
            alert("Data will be updated to this date: " + dateText);
        }
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });
});

$(document).ready(function() {
    let initialAmount = parseFloat('{{ $data->amount }}');
    let availableAmount = 0;

    var initialFundId = $('#fund_id').val();

    if (initialFundId) {
        $.ajax({
            url: "{{ route('fund.amount') }}",
            type: 'POST',
            data: {
                fund_id: initialFundId,
                _token: '{{ csrf_token() }}'
            },
            success: function(data) {
                availableAmount = parseFloat(data);
                let amount = $('#amount').val();
                $('#availableAmount').text(availableAmount + initialAmount);
                $('#showAmount').show();
            },
            error: function(xhr, status, error) {
                console.log('Error:', error);
            }
        });
    }

    $('#fund_id').on('change', function() {
        var fund_id = $(this).val();

        if (fund_id) {
            $.ajax({
                url: "{{ route('fund.amount') }}",
                type: 'POST',
                data: {
                    fund_id: fund_id,
                    _token: '{{ csrf_token() }}'
                },
                success: function(data) {
                    availableAmount = parseFloat(data);
                    if (fund_id == initialFundId) {
                        $('#availableAmount').text(availableAmount + initialAmount);
                    } else {
                        $('#availableAmount').text(availableAmount);
                    }
                    $('#showAmount').show();
                },
                error: function(xhr, status, error) {
                    console.log('Error:', error);
                }
            });
        } else {
            $('#showAmount').hide();
        }
    });

    $('#amount').on('input', function() {
        var inputAmount = parseFloat($(this).val());

        if (inputAmount > availableAmount + initialAmount) {
            toastr.error('The amount cannot exceed the available amount of ' + (availableAmount + initialAmount));
            $(this).val(availableAmount + initialAmount);
        }
    });
});

</script>
@endpush
@endsection
