@extends('dashboard.master')
@section('title', 'Loan Given Details')
@section('content')
    <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        .printArea {
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            padding: 20px;
        }

        @media print {
            body * {
                visibility: hidden;
            }

            .printArea,
            .printArea * {
                visibility: visible;
            }

            .printArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }
        }
    </style>

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Loan Given Details</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('loan.given.create') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                        <a title="Print" id="printButton" type="button" class="btn btn-sm btn-danger">
                            <i class="fas fa-file mr-1"></i>
                            Print
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body printArea">
                        <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                            style="width:100%; height:150px; margin-bottom:20px;">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover print-table"
                            style="text-align: left">
                            <thead>
                                {{-- <tr>
                                <th class="text-left" width="30%">Receipt No</th>
                                <td class="text-left" width="70%">{{ $receipt_no->id ?? '' }}</td>
                            </tr> --}}
                                <tr>
                                    <th class="text-left" width="30%">Date</th>
                                    <td class="text-left" width="70%">
                                        {{ \Carbon\Carbon::parse($data->date)->format('d-M-Y') ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Taken By</th>
                                    <td class="text-left" width="70%">{{ $data->name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Phone</th>
                                    <td class="text-left" width="70%">{{ $data->phone ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Amount</th>
                                    <td class="text-left" width="70%">{{ $data->amount ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Status</th>
                                    <td class="text-left" width="70%">
                                        @if ($data->status == 1)
                                            <span class="badge badge-primary">Paid</span>
                                        @else
                                            <span class="badge badge-danger">Unpaid</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Purpose</th>
                                    <td class="text-left" width="70%">{{ $data->purpose ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th class="text-left" width="30%">Note</th>
                                    <td class="text-left" width="70%">{{ $data->note ?? '' }}</td>
                                </tr>

                            </thead>
                        </table>
                        <div id="footer-img">
                            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer"
                                style="width:100%; height:150px; margin-top:20px;">
                        </div>

                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script>
            $('#printButton').on('click', function() {
                window.print();
            });
        </script>
    @endpush
@endsection
