@extends('dashboard.master')
@section('title', 'Loan Taken Details')
@push('css')

<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
     .swal-title{
        font-size: 17px;
        color: red;
        padding: 0;
    }
    .swal-text{
        margin-top: 5px !important;
        color: black;
        background-color: white;
        box-shadow: none;
    }
    .swal-modal{
        max-width: 299px ;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }

@media print {
    body * {
        visibility: hidden;
    }

    #printArea, #printArea * {
        visibility: visible;
    }

    #printArea {
        position: relative;
        left: 0;
        top: 0;
        width: 100%;
    }

    .table-container {
        margin-top: 20px;
        margin-bottom: 20px;
    }

    table {
        width: 100% !important;
        page-break-inside: auto;
    }

    tr {
        page-break-inside: avoid;
        page-break-after: auto;
    }

    .dataTables_length, .dataTables_filter, .dataTables_paginate,
    .dataTables_info, .print, .hideClass, .dt-buttons {
        display: none !important;
    }

    th.action, td.action {
        display: none !important;
    }

    @page {
        size: A4 portrait;
        margin: 10mm;
    }

    thead {
        display: table-header-group;
    }

    tfoot {
        display: table-footer-group;
    }

    tr {
        page-break-inside: avoid;
    }

    /* .print-only {
        display: block !important;
        width: 100%;
    } */

    .print-only img {
        width: 100% !important;
        max-width: 100% !important;
    }
}

</style>

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Loan Taken Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('loan.taken.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
            <div class="card" id="printArea">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr class="print-only">
                                <td colspan="4" style="padding:0;">
                                    <img src="{{ asset('img/' . $invoice->invoice_header) }}" style="width:100%;">
                                </td>
                            </tr>
                            <tr>
                                <th>SN</th>
                                <th>Date</th>
                                <th>Return By</th>
                                <th>Amount</th>
                                <th class="action hideClass">Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                        <tfoot>
                            <tr class="print-only">
                                <td colspan="4" style="padding:0;">
                                    <img src="{{ asset('img/' . $invoice->invoice_footer) }}" style="width:100%;">
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                    <button class="btn btn-danger float-left mt-5 print" id="print">Print</button>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>

$(document).ready( function () {
    var url = $(this).attr('href');
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: url,
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: true, orderable: true},
            {data: 'date', name: 'date'},
            {data: 'name', name: 'name'},
            {data: 'amount', name: 'amount'},
            {data: 'action', searchable: false, orderable: false, className: 'hideClass'}
        ],
        dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
        buttons: [
            {
                extend: 'copy',
                className: 'btn-sm btn-info',
                title: 'Loan Taken List',
                header: true,
                footer: true,
            },
           
            {
                extend: 'print',
                className: 'btn-sm btn-danger',
                title: 'Loan Taken List',
                pageSize: 'A2',
                header: true,
                footer: true,
                orientation: 'landscape',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'colvis',
                className: 'btn-sm btn-warning',
                text: 'Column Visibility',
                title: 'Column Visibility',
                columns: ':not(:first-child)'
            }
        ],
        });
    });

    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                }
            });

            const url = $(this).data('remote');
            swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
            });
        });

$(document).ready(function() {
    $('.print-only').hide();
    $('#print').on('click', function() {
        $('th.action, td.action').hide();
        $('.print-only').show();
        $('.hideClass').show();
        window.print();

        setTimeout(function() {
            $('.print-only').hide();
            $('th.action, td.action').show();
        }, 500);
    });
});

//toastr.options.timeOut = 300;
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };
    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection
