@extends('dashboard.master')
@section('title', 'Roshid Distribute Create')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Roshid Distribute Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('roshid.distribute.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ now()->format('Y-m-d') }}" class="form-control" placeholder="date" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Select Roshid<span class="text-red">*</span></label>
                                    <select name="roshid_stock_id" id="roshid_stock_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($items as $item)
                                        <option value="{{ $item->id }}"
                                            data-id="{{ $item->id }}"
                                            data-serial="{{ $item->serial_no ?? '' }}"
                                            data-taken_by="{{ $item->roshid_taken_by ?? '' }}"
                                            data-taken_name="{{ $item->takenby->name ?? '' }}"
                                            data-status="{{ $item->status ?? ''}}">
                                            {{ $item->name }} || {{ $item->serial_no }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Taken By<span class="text-red">*</span></label>
                                    <input type="text" name="name" id="name" class="form-control" placeholder="enter name" required>
                                    <input type="hidden" name="roshid_taken_by" id="roshid_taken_by" class="form-control" placeholder="enter name" >
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Phone</label>
                                    <input type="text" name="phone" id="phone" class="form-control" placeholder="enter phone">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Page</label>
                                    <input type="number" name="page" id="page" class="form-control" placeholder="enter page">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control" placeholder="write note here ..."></textarea>
                                </div>
                            </div>

                        </div>

						<div class="row mt-20 hideClass">
							<div class="col-sm-12">
								<button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
							</div>
						</div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(document).ready(function() {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd'
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });

    $('#roshid_stock_id').change(function() {
        var selectedOption = $(this).find('option:selected');
        var taken_by = selectedOption.data('taken_by');
        var takenName = selectedOption.data('taken_name');
        $('#name').val(takenName);
        $('#roshid_taken_by').val(taken_by);
        if (takenName) {
            $('#name').prop('readonly', true);
        } else {
            $('#name').prop('readonly', false);
        }
    });
});
</script>
@endpush
@endsection
