@extends('dashboard.master')
@section('title', 'Roshid Stock')
@push('css')

<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
     .swal-title{
        font-size: 17px;
        color: red;
        padding: 0;
    }
    .swal-text{
        margin-top: 5px !important;
        color: black;
        background-color: white;
        box-shadow: none;
    }
    .swal-modal{
        max-width: 299px ;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }

</style>

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Roshid Stock</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addClass">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Name</th>
                                <th>First Serial</th>
                                <th>Last Serial</th>
                                <th>Total Book</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

{{-- add modal --}}
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Create Roshid Stock')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf

                    <label for="name" class="row col-form-label">Roshid Name<span class="text-red">*</span></label>

                    <div class="form-group row">
                        <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter roshid name" required>
                        @error('name')
                        <span class="text-danger" role="alert">
                            <p>{{ $message }}</p>
                        </span>
                        @enderror
                    </div>

                    <label for="name" class="row col-form-label">First Serial<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <input type="text" name="first_serial" id="first_serial" value="{{ old('first_serial') }}" class="form-control" placeholder="Enter first serial" required>
                    </div>

                    <label for="last_serial" class="row col-form-label">Last Serial</label>
                    <div class="form-group row">
                        <input type="text" name="last_serial" id="last_serial" value="{{ old('last_serial') }}" class="form-control" placeholder="Enter last serial " >
                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="save" class="btn btn-primary">{{ __('Create')}}</button>
            </div>
        </div>
    </div>
</div>

{{-- edit modal --}}
<div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Roshid Stock')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="edit-menu" action="#">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="" id="editId">
                    <label for="name" class="row col-form-label">Roshid Name<span class="text-red">*</span></label>
                     <div class="form-group row">
                        <input type="text" name="name" id="nameEdit" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" placeholder="Enter roshid name" required>
                        @error('name')
                        <span class="text-danger" role="alert">
                            <p>{{ $message }}</p>
                        </span>
                        @enderror
                    </div>

                    <label for="name" class="row col-form-label">First Serial<span class="text-red">*</span></label>
                    <div class="form-group row">
                        <input type="text" name="first_serial" id="first_serialEdit" value="{{ old('first_serial') }}" class="form-control" placeholder="Enter first serial" required>
                    </div>

                    <label for="last_serial" class="row col-form-label">Last Serial</label>
                    <div class="form-group row">
                        <input type="text" name="last_serial" id="last_serialEdit" value="{{ old('last_serial') }}" class="form-control" placeholder="Enter last serial " >
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="update" class="btn btn-primary">{{ __('Update')}}</button>
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
$(document).ready(function($){
    $('#save').on('click',function (event) {
    event.preventDefault();
    var url = "{{ route('roshid.stock.store') }}";
    var name = $('#name').val();
    var first_serial = $('#first_serial').val();
    var last_serial = $('#last_serial').val();
    $.ajax({
        url: url,
        type: "get",
        data: {
            name : name ,
            first_serial : first_serial,
            last_serial : last_serial,
        },
        success: function(data) {
            if (data.success === true) {
                location.reload();
                toastr.success(data.message);
                $('#add-class').trigger('clear');
                $('#add-class')[0].reset();
            }else{
                toastr.error(data.message);
                $('#add-class').trigger('clear');
                $('#add-class')[0].reset();
                $('#addClass').modal('show');
            }
        },

    });
    $.noConflict();
    $('#addClass').modal('hide');
});
});

$('#data_table').on('click', '#edit[href]', function (e) {
    e.preventDefault();
    var url = $(this).attr('href');

    $.ajax({
        type: "GET",
        url: url,
        success: function (resp) {
            if (resp) {
                $('#nameEdit').val(resp.name);
                $('#first_serialEdit').val(resp.first_serial);
                $('#last_serialEdit').val(resp.last_serial);
                $('#editId').val(url.split('/').pop());
            } else {
                alert('Failed to load data for editing.');
            }
        },
        error: function () {
            alert('Error fetching data. Please try again.');
        }
    });
});


$('#update').on('click',function (event) {
        event.preventDefault();
        var id = $('#editId').val();
        var name = $('#nameEdit').val();
        var first_serial = $('#first_serialEdit').val();
        var last_serial = $('#last_serialEdit').val();
        var url = '{{ route("roshid.stock.update",":id") }}';

        $.ajax({
        url: url.replace(':id', id),
        'type':'GET',
        'data':{
            name : name,
            first_serial : first_serial,
            last_serial : last_serial,
        },
        success:function(data)
        {
            if (data.success === true) {
                toastr.success(data.message);
                $('#data_table').DataTable().ajax.reload();
                $('#editClass').modal('hide');
            }else{
                toastr.error(data.message);
                $('#editClass').modal('show');
            }
        }
    });

});

$(document).ready( function () {
    var dTable = $('#data_table').DataTable({
        order: [],
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: false,
        serverSide: true,
        scrollX: true,
        autoWidth: false,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: "{{route('roshid.stock')}}",
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: true, orderable: true},
            {data: 'name', name: 'name'},
            {data: 'first_serial', name: 'first_serial'},
            {data: 'last_serial', name: 'last_serial'},
            {data: 'total_books', name: 'total_books'},
            {data: 'action', searchable: false, orderable: false}
        ],
        dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
        buttons: [
            {
                extend: 'copy',
                className: 'btn-sm btn-info',
                title: 'Roshid Stock List',
                header: true,
                footer: true,
            },

            {
                extend: 'excel',
                className: 'btn-sm btn-success',
                title: 'Roshid Stock List',
                header: true,
                footer: true,
                exportOptions: {
                    columns: [0, 1, 2, 3, 4],
                    stripHtml: true
                },
            },
           
            {
                extend: 'print',
                className: 'btn-sm btn-danger',
                title: 'Roshid Stock List',
                pageSize: 'A2',
                header: true,
                footer: true,
                orientation: 'landscape',
                exportOptions: {
                    columns: ':visible'
                }
            },
            {
                extend: 'colvis',
                className: 'btn-sm btn-warning',
                text: 'Column Visibility',
                title: 'Column Visibility',
                columns: ':not(:first-child)'
            }
        ],
        });
    });

    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                }
            });

            const url = $(this).data('remote');
            swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
            });
        });

    //  toastr.options.timeOut = 300;
    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection




