@extends('dashboard.master')
@section('title', 'Roshid Taken Create')
@push('css')
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.1/themes/base/jquery-ui.css">
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Roshid Taken Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('roshid.taken.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="date">Date<span class="text-red">*</span></label>
                                    <input type="text" name="date" id="date" value="{{ now()->format('Y-m-d') }}" class="form-control" placeholder="Enter Date" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="roshid_refund_by">Name<span class="text-red">*</span></label>
                                    <select name="roshid_refund_by" id="roshid_refund_by" class="form-control" required>
                                        <option value="">Select One</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}"
                                                data-roshid="{{ $user->roshid_stock_id }}"
                                                data-rname="{{ $user->roshid->name }}"
                                                data-rserial="{{ $user->roshid->serial_no }}"
                                                data-phone="{{ $user->phone }}"
                                                data-status="{{ $user->roshid->status }}">
                                                {{ $user->name }} || {{ $user->phone }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="roshid_name">Roshid<span class="text-red">*</span></label>
                                    <input type="text" name="roshid_name" id="roshid_name" class="form-control" readonly>
                                    <input type="hidden" name="roshid_stock_id" id="roshid_stock_id" class="form-control" placeholder="Roshid ID" readonly>
                                    <input type="hidden" name="status" id="status" class="form-control" placeholder="Roshid Status" readonly>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="serial_no">Serial No<span class="text-red">*</span></label>
                                    <input type="text" name="serial_no" id="serial_no" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="phone">Phone</label>
                                    <input type="text" name="phone" id="phone" class="form-control" placeholder="Enter Phone Number">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="page">Page</label>
                                    <input type="number" name="page" id="page" class="form-control" placeholder="Enter Page">
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="amount">Amount</label>
                                    <input type="number" name="amount" id="amount" class="form-control" placeholder="Enter Amount">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="">Select Fund<span class="text-red">*</span></label>
                                    <select name="fund_id" id="fund_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($funds as $fund)
                                        <option value="{{ $fund->id }}">{{ $fund->name ?? '' }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="note">Note</label>
                                    <textarea name="note" id="note" cols="1" rows="1" class="form-control" placeholder="Write note here..."></textarea>
                                </div>
                            </div>

                        </div>

                        <div class="row mt-20">
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
$(document).ready(function() {
    $('#date').datepicker({
        dateFormat: 'yy-mm-dd'
    });

    $('#date').inputmask('9999-99-99', {
        placeholder: 'yyyy-mm-dd',
        clearIncomplete: true
    });

    $('#roshid_refund_by').change(function() {
        var selectedOption = $(this).find('option:selected');
        var roshidId = selectedOption.data('roshid');
        var roshidName = selectedOption.data('rname');
        var roshidStatus = selectedOption.data('status');
        var serial = selectedOption.data('rserial');
        var phone = selectedOption.data('phone');

        $('#roshid_name').val(roshidName);
        $('#roshid_stock_id').val(roshidId);
        $('#phone').val(phone);
        $('#serial_no').val(serial);
        $('#status').val(roshidStatus);
    });
});
</script>
@endpush
@endsection
