@extends('dashboard.master')
@section('title', 'Student Sponsor Create')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Sponsor Create</b>
                    </span>
                </div>

                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="{{ route('student.sponsor.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="donar_id">Donar<span class="text-red">*</span></label>
                                    <select name="donar_id" id="donar_id" class="form-control" required>
                                        <option value="">Select One</option>
                                       @foreach ($donars as $item)
                                       <option value="{{ $item->id }}">{{ $item->name }} | {{ $item->phone ?? '' }}</option>
                                       @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="form-group">
                                    <label for="student_id">Students<span class="text-red">*</span></label>
                                    <select name="student_id" id="student_id" class="form-control" required>
                                        <option value="">Select One</option>
                                       @foreach ($students as $item)
                                       <option value="{{ $item->id }}">{{ $item->name }} | {{ $item->roll_no ?? '' }} | {{ $item->stuclass->name ?? '' }}</option>
                                       @endforeach
                                    </select>
                                </div>
                            </div>

                            {{-- <div class="col-md-2">
                                <div class="form-group">
                                    <label for="amount">Monthly Amount</label>
                                    <input type="text" name="amount" id="amount" class="form-control" placeholder="Enter amount" readonly>
                                </div>
                            </div> --}}

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="note">Note</label>
                                    <textarea name="note" id="note" cols="2" rows="2" class="form-control" placeholder="Write note here..."></textarea>
                                </div>
                            </div>

                        </div>

                        <div class="row mt-20">
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-primary mr-2">Save</button>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>

<script>
$('#student_id').on('change', function() {
    var student_id = $(this).val();
    $.ajax({
        url: "{{ route('student.sponsor.amount') }}",
        type: 'POST',
        data: {
            student_id: student_id,
            _token: '{{ csrf_token() }}'
        },
        success: function(data) {
            $('#amount').val(data.averageAmount);
        }
    });
});
$(document).ready(function() {

@if(Session::has('success'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true,
        "timeOut": 1000
    };
    toastr.success("{{ session('success') }}");
@endif

@if(Session::has('error'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true,
    };
    toastr.error("{{ session('error') }}");
@endif

});


</script>
@endpush
@endsection

