@extends('dashboard.master')
@section('title', 'Data Delete Setting')

@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<style>
    .multi-line-text {
        display: block;
        line-height: 1.6;
        max-height: 3.2em;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: normal;
    }

    input[readonly] {
        background-color: #f5f5f5 !important;
        color: #333;
        cursor: not-allowed;
    }

    .warning-box {
        border: 1px solid #ced4da;
        background-color: #f5f5f5;
        padding: 15px;
        border-radius: 5px;
        margin-bottom: 15px;
    }

    .warning-box + .warning-box {
        margin-top: 20px;
    }
</style>
@endpush

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Data Delete Setting</b>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">

                    <!-- First Warning Box -->
                    <div class="warning-box">
                        <span class="multi-line-text">
                            এই সেটিংস খুব গুরুত্বপূর্ণ, তাই দিন ঠিক করার সময় সতর্ক থাকুন। আপনি যত দিন বেছে নেবেন, সেই সময়ের পর কোনো ট্রানজেকশন ডিলেট করা যাবে না। পরে যদি এই সময় বদলাতে চান, তাহলে পুরো সফটওয়্যার রিসেট করতে হবে। তাই ভালোভাবে ভেবে দিন নির্ধারণ করুন।
                        </span>
                    </div>

                    <!-- Second Warning Box -->
                    <div class="warning-box">
                        <span class="multi-line-text mt-2 d-block">
                            This is a critical setting, so please choose the number of days carefully. Once set, transactions cannot be deleted after the selected period. If you wish to change this later, a full system reset will be required. Therefore, make your selection thoughtfully.
                        </span>
                    </div>

                    <form id="delete-setting-form" enctype="multipart/form-data" action="{{ route('data.delete.store') }}" method="POST">
                        @csrf
                        <div class="row mt-4">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="day">Set Day For Delete <span class="text-red">*</span></label>
                                    <input type="number" name="day" id="day" class="form-control"
                                           value="{{ isset($data) ? $data->day : old('day') }}"
                                           placeholder="Enter day" required @if(isset($data) && $data->day) readonly @endif>
                                </div>
                            </div>
                        </div>

                        @if(!isset($data) || !$data->day)
                        <div class="row">
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

<script>
@if(Session::has('success'))
    toastr.options = {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };
    toastr.success("{{ session('success') }}");
@endif

@if(Session::has('error'))
    toastr.options = {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
@endif

$(document).ready(function () {
    $('#delete-setting-form').on('submit', function (e) {
        @if(!isset($data) || !$data->day)
        e.preventDefault();
        swal({
            title: "আপনি কি নিশ্চিত?",
            text: "ডাটা সেভ করার পর আর এডিট করা যাবে না",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        }).then((willSubmit) => {
            if (willSubmit) {
                this.submit();
            }
        });
        @endif
    });
});
</script>
@endpush
@endsection
