@extends('dashboard.master')
@section('title', 'Device Setting')
@push('css')

<link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
<link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

<style>
     .swal-title{
        font-size: 17px;
        color: red;
        padding: 0;
    }
    .swal-text{
        margin-top: 5px !important;
        color: black;
        background-color: white;
        box-shadow: none;
    }
    .swal-modal{
        max-width: 299px ;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }

         #data_table {
            /* width: 100% !important; */
            /* table-layout: auto !important; */
        }

         #data_table th,
        #data_table td {
            white-space: nowrap;
            /* এটা দিলে কলামের মধ্যে data কাটবে না, বরং scroll আসবে */
        }

</style>

 @endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Device Setting</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>

                    @if(Auth::user()->role_id == 1 || Auth::user()->type == 1 || Auth::user()->canPerm('device_settings.create'))
					<a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#addClass">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
                    @endif
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Device Name</th>
                                <th>Device IP </th>
                                <th>Device Port</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

{{-- add modal --}}
<div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Create Device Setting')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf

                    <div class="row">
                        <div class="mb-3 col-md-12">
                            <label>Device Name<span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="name" placeholder="zkt eco" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Device IP<span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="device_ip" placeholder="192.168.0.173" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Device Port <span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="device_port" placeholder="4370" required>
                        </div>

                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="save" class="btn btn-primary">{{ __('Create')}}</button>
            </div>
        </div>
    </div>
</div>

{{-- edit modal --}}
<div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Device Setting')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <form id="edit-menu" action="#">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="" id="editId">

                    <div class="row">
                        <div class="mb-3 col-md-12">
                            <label>Device Name<span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="nameEdit" placeholder="ZKT eco" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Device IP<span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="device_ipEdit" placeholder="192.168.0.173" required>
                        </div>
                        <div class="mb-3 col-md-12">
                            <label>Device Port <span class="text-red">*</span></label>
                            <input class="form-control" type="text" name="" id="device_portEdit" placeholder="4370" required>
                        </div>

                    </div>

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close')}}</button>
                <button type="button" id="update" class="btn btn-primary">{{ __('Update')}}</button>
            </div>
        </div>
    </div>
</div>
@push('js')
<script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    // add menu
    $(document).ready(function($){

        $(document).ready(function() {
            $('#save').on('click', function (event) {
                event.preventDefault();

                var url = "{{ route('device.setting.store') }}";
                var name = $('#name').val();
                var device_ip = $('#device_ip').val();
                var device_port = $('#device_port').val();

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        name : name,
                        device_ip : device_ip,
                        device_port : device_port,
                        _token: '{{ csrf_token() }}',
                    },
                    success: function(data) {
                        if (data.success) {
                            toastr.success(data.message);
                            $('.add-class').trigger('clear');
					        $('.add-class')[0].reset();
                            location.reload();
					        $('#data_table').DataTable().ajax.reload();
                        } else {
                            toastr.error(data.message);
                            $('#add-class')[0].reset();
                            $('#addClass').modal('show');
                        }
                    },
                    error: function(xhr, status, error) {
                        toastr.error('An error occurred. Please try again.');
                    }
                });

                $.noConflict();
                $('#addClass').modal('hide');
            });
        });


    $('#data_table').on('click', '#edit[href]', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        $.ajax({
            type: "GET",
            url: url,
            success: function(resp) {
                $('#nameEdit').val(resp.name);
                $('#device_ipEdit').val(resp.device_ip);
                $('#device_portEdit').val(resp.device_port);
                $('#editId').val(resp.id);
            }
        });
    });

    $('#update').on('click',function (event) {
        event.preventDefault();
        var id = $('#editId').val();
        var name = $('#nameEdit').val();
        var device_ip = $('#device_ipEdit').val();
        var device_port = $('#device_portEdit').val();
        var url = '{{ route("device.setting.update",":id") }}';
        $.ajax({
            url: url.replace(':id', id),
            type: 'POST',
            data: {
                name: name,
                device_port: device_port,
                device_ip: device_ip,
                _token: '{{ csrf_token() }}',
            },
            success:function(data) {
                if (data.success === true) {
                    toastr.success(data.message);
                    $('#data_table').DataTable().ajax.reload();
                    $('#editClass').modal('hide');
                } else {
                    toastr.error(data.message);
                    $('#editClass').modal('show');
                }
            }
        });
    });
});

$(document).ready( function () {
    var dTable = $('#data_table').DataTable({
        order: [],
         scrollX: true,
          autoWidth: false,
        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        processing: true,
        responsive: true,
        serverSide: true,
        scroller: {
            loadingIndicator: false
        },
        language: {
              processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
            },
        pagingType: "full_numbers",
        ajax: {
            url: "{{route('device.setting')}}",
            type: "get"
        },

        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex', searchable: true, orderable: true},
            {data: 'name', name: 'name'},
            {data: 'device_ip', name: 'device_ip'},
            {data: 'device_port', name: 'device_port'},
            {data: 'action', searchable: false, orderable: false}
        ],

        });
    });

    $('#data_table').on('click', '.btn-delete[data-remote]', function (e) {
            e.preventDefault();

            $.ajaxSetup({
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                }
            });

            const url = $(this).data('remote');
            swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    url: url,
                    type: 'get',
                    dataType: 'json',
                    data: {submit: true, _method: 'delete', _token: "{{ csrf_token() }}"}
                }).always(function (data) {
                    $('#data_table').DataTable().ajax.reload();
                    if (data.success === true) {
                        toastr.success(data.message, { positionClass: 'toast-bottom-full-width', });
                    }else{
                        toastr.error(data.message, { positionClass: 'toast-bottom-full-width', });
                    }
                });
            }
            });
        });

    //  toastr.options.timeOut = 300;
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection




