@extends('dashboard.master')
@section('title', 'Exam Routing')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>পরীক্ষার রুটিন</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('exam.routing.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        
                        <div class="card mt-3">
                            <div class="card-body">
                                <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                    <thead>
                                        <tr>
                                            <th>SN</th>
                                           
                                            <th>Session</th>
                                            <th>Exam</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody></tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>


    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.select2').select2();

                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    serverSide: true,
                    scrollX: true,
                    autoWidth: false,
                    ajax: {
                        url: "{{ route('exam.routing') }}",
                        type: "get"
                    },
                    columns: [  { data: 'DT_RowIndex', orderable: false, searchable: false },
                       
                        {
                            data: 'session',
                            name: 'session'
                        },
                        {
                            data: 'exam',
                            name: 'exam'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],
                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Exam Routing List'
                        },
                         {
                            extend: 'excel',
                            className: 'btn-sm btn-success',
                            title: 'Exam Routine',
                            exportOptions: {
                                columns: [0, 1,2],
                                stripHtml: true
                            }
                        },
                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Exam Routing List',
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility'
                        }
                    ],
                });

            });

            $("#class_id, #session_id, #exam_id").on("change", function() {
                table.ajax.reload();
            });

            $("#class_id, #session_id").on("change", function() {
                getExamBySessionClass();
            });


            @if (Session::has('success'))
                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.error("{{ session('error') }}");
            @endif




            function getExamBySessionClass() {
                var class_id = $('#class_id').val();
                var session_id = $('#session_id').val();
                $.ajax({
                    url: "{{ route('exam.routing.getExam') }}",
                    type: "GET",
                    data: {
                        class_id: class_id,
                        session_id: session_id
                    },
                    success: function(data) {
                        console.log('exam session data', data);
                        $("#exam_id").html(data);
                    }
                });
            }


            $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                e.preventDefault();
                const url = $(this).data('remote');
                swal({
                    title: "Are you sure?",
                    text: "This will permanently delete the routing and its details. This action cannot be undone.",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: url,
                            type: 'get',
                            dataType: 'json',
                            data: {
                                submit: true,
                                _method: 'delete',
                                _token: "{{ csrf_token() }}"
                            }
                        }).always(function(data) {
                            $('#data_table').DataTable().ajax.reload();
                            if (data.success === true) {
                                toastr.success(data.message);
                            } else {
                                toastr.error(data.message);
                            }
                        });
                    }
                });
            });


        </script>
    @endpush
@endsection
