@extends('dashboard.master')
@section('title', 'View Exam Routing')
<?php
$invoiceBgPath = 'back_height.jpg';
if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
    $potentialBgFile = 'img/' . $invoice->invoice_bg;
    if (file_exists(public_path($potentialBgFile))) {
        $invoiceBgPath = $potentialBgFile;
    }
}
?>
@push('css')
    <style>
        @media print {
            body * {
                visibility: hidden;
            }

            #printArea,
            #printArea * {
                visibility: visible;
            }

            #printArea {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat !important;
            }

            .container,
            .container-fluid,
            .content-wrapper>.content {
                padding: 0 !important;
            }

            .print-table th,
            .print-table td {
                background: transparent !important;
            }
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>পরীক্ষার রুটিন বিস্তারিত</b></span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ route('exam.routing') }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>

                        <button type="button" onclick="printDiv('printArea')" class="btn btn-sm btn-success ml-2">
                            <i class="fas fa-print mr-1"></i> Print
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                <div class="card" id="printArea">
                    <div class="card-body">
                        <!-- Optional header for print -->
                        <div class="text-center mb-3 d-print-block d-none">
                            <img src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                                style="width:100%; height:150px; margin-bottom:30px;">
                            <hr>
                        </div>

                        {{-- <h5>Exam Routing Information</h5> --}}
                        <table class="table table-bordered print-table">
                            <tr>
                                <th>Class</th>
                                <td>{{ $examRouting->class->name ?? '' }}</td>
                                <th>Session</th>
                                <td>{{ $examRouting->session->name ?? '' }}</td>
                                <th>Exam</th>
                                <td>{{ $examRouting->exam->name ?? '' }}</td>
                            </tr>
                        </table>

                        <hr>
                        {{-- <h5>Exam Details</h5> --}}
                        <table class="table table-bordered print-table">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Subject</th>
                                    <th>Date</th>
                                    <th>Day</th>
                                    <th>Room</th>
                                    <th>Time</th>
                                    <th>Marks</th>
                                    <th>Summary</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($examRouting->details->sortBy('date') as $key => $detail)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $detail->subject->name ?? '' }}</td>
                                        <td>{{ \Carbon\Carbon::parse($detail->date)->format('d M Y') }}</td>
                                        <td>{{ $detail->day }}</td>
                                        <td>{{ $detail->room }}</td>
                                        <td>{{ $detail->time }}</td>
                                        <td>{{ $detail->mark }}</td>
                                        <td>{{ $detail->summary }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">No details found.</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>

                        <!-- Optional footer for print -->
                        <div class="mt-4 text-center d-print-block d-none">
                            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer"
                                style="width:100%; height:150px;">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script>
        function printDiv(divId) {
            window.print();
        }
    </script>
@endpush
