@extends('dashboard.master')
@section('title', 'Exam Grade')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="{{ asset('backend/css/toggle.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }

        .swal-title {
            font-size: 17px;
            color: red;
            padding: 0;
        }

        .swal-text {
            margin-top: 5px !important;
            color: black;
            background-color: white;
            box-shadow: none;
        }

        .swal-modal {
            max-width: 299px;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Exam Wise Grade</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="#" type="button" class="btn btn-sm btn-primary" data-toggle="modal"
                            data-target="#addClass">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <input type="hidden" name="examid" id="examId" value="{{ $examId }}">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>

                                    <th>Exam</th>


                                    <th>Session</th>
                                    <th>Exam Mark</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </section>
    </div>

    {{-- add modal --}}
    <div class="modal fade" id="addClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="demoModalLabel">{{ __('Create Exam Grade') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form class="forms-sample add-class" enctype="multipart/form-data" action="#" method="POST">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <!-- Left column -->
                            <div class="col-md-6">


                                <div class="form-group">
                                    <label for="exam_id">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id"
                                        class="form-control @error('exam_id') is-invalid @enderror" required>
                                        <option value="">Select Exam</option>
                                        @foreach ($exams as $exam)
                                            <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('exam_id')
                                        <span class="text-danger">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exam_mark">Exam Mark<span class="text-red">*</span></label>
                                    <input type="text" name="exam_mark" id="exam_mark" value="{{ old('exam_mark') }}"
                                        class="form-control" placeholder="Enter exam mark" required>
                                </div>


                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="session_id">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id"
                                        class="form-control @error('session_id') is-invalid @enderror" required>
                                        <option value="">Select Session</option>
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('session_id')
                                        <span class="text-danger">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                            </div>




                            <div class="col-md-12">
                                <div class="form-group repeat-group">
                                    <label>Grade Range & GPA<span class="text-red">*</span></label>
                                    <div class="row grade-item">
                                        <div class="col-md-3">
                                            <input type="text" name="start_mark[]" class="form-control start_mark"
                                                placeholder="Start mark" required>
                                        </div>
                                        <div class="col-md-3">
                                            <input type="text" name="end_mark[]" class="form-control end_mark"
                                                placeholder="End mark" required>
                                        </div>
                                        <div class="col-md-3">
                                            <input type="text" name="grade[]" class="form-control grade"
                                                placeholder="Grade" required>
                                        </div>
                                        <div class="col-md-2">
                                            <input type="number" step="any" name="gpa[]" class="form-control gpa"
                                                placeholder="GPA" required>
                                        </div>
                                        <div class="col-md-1">
                                            <button type="button" class="btn btn-danger btn-sm remove-grade">×</button>
                                        </div>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-sm btn-success mt-2" id="addMoreGrade">+ Add
                                    More</button>

                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">{{ __('Close') }}</button>
                        <button type="button" id="save" class="btn btn-primary">{{ __('Create') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    {{-- edit modal --}}
    <div class="modal fade" id="editClass" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="demoModalLabel">{{ __('Edit Exam Wise Grade') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>

                <form id="edit-menu" action="#" method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="id" id="editId">

                    <div class="modal-body">
                        <div class="row">
                            <!-- Left Column -->
                            <div class="col-md-6">
                                

                                <div class="form-group">
                                    <label for="exam_idEdit">Exam<span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_idEdit" class="form-control" required>
                                        <option value="">Select Exam</option>
                                        @foreach ($exams as $exam)
                                            <option value="{{ $exam->id }}">{{ $exam->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="exam_markEdit">Exam Mark<span class="text-red">*</span></label>
                                    <input type="number" name="exam_mark" id="exam_markEdit" class="form-control"
                                        placeholder="Enter exam mark" required>
                                </div>
                            </div>

                            <!-- Right Column -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="session_idEdit">Session<span class="text-red">*</span></label>
                                    <select name="session_id" id="session_idEdit" class="form-control" required>
                                        <option value="">Select Session</option>
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                
                            </div>

                            <!-- Grade Range (Dynamic Inputs) -->
                            <div class="col-md-12">
                                <div class="form-group edit-repeat-group">
                                    <label>Grade Range & GPA<span class="text-red">*</span></label>
                                    <!-- Dynamic rows will be injected here -->
                                </div>
                                <button type="button" class="btn btn-sm btn-success mt-2" id="addMoreGradeEdit">+ Add
                                    More</button>
                            </div>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" id="update" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            // add menu
            $(document).ready(function($) {
                $('#save').on('click', function(event) {
                    event.preventDefault();
                    var url = "{{ route('exam.wise.grade.store') }}";
                    let startMarks = [];
                    let endMarks = [];
                    let grades = [];
                    let gpas = [];

                    $('.start_mark').each(function() {
                        startMarks.push($(this).val());
                    });
                    $('.end_mark').each(function() {
                        endMarks.push($(this).val());
                    });
                    $('.grade').each(function() {
                        grades.push($(this).val());
                    });
                    $('.gpa').each(function() {
                        gpas.push($(this).val());
                    });

                   
                    var exam_id = $('#exam_id').val();
                    var session_id = $('#session_id').val();
                    var exam_mark = $('#exam_mark').val();




                    $.ajax({
                        url: url,
                        type: "get",
                        data: {
                            grade: grades,
                          
                          
                            start_mark: startMarks,
                            end_mark: endMarks,
                            gpa: gpas,
                            session_id: session_id,
                            exam_mark: exam_mark,
                            exam_id: exam_id,
                        },
                        success: function(data) {
                            console.log('data', data);
                            if (data.success === true) {
                                location.reload();
                                toastr.success(data.message);
                                $('#add-class').trigger('clear');
                                $('#add-class')[0].reset();
                            } else {
                                toastr.error(data.message);
                                $('#add-class').trigger('clear');
                                $('#add-class')[0].reset();
                                $('#addClass').modal('show');
                            }
                        },

                    });
                    $.noConflict();
                    $('#addClass').modal('hide');
                });
            });

            //edit menu
            $('#data_table').on('click', '#edit[href]', function(e) {
                e.preventDefault();
                var url = $(this).attr('href');

                $.ajax({
                    type: "GET",
                    url: url,
                    success: function(resp) {
                        // Set basic fields
                        console.log(resp);
                        $('#gradeEdit').val(resp
                            .grade
                        ); // Only works if single grade (you can remove this if using repeatable fields only)
                     
                        $('#exam_idEdit').val(resp.exam_id).trigger('change');
                        $('#session_idEdit').val(resp.session_id).trigger('change');
                        $('#exam_markEdit').val(resp.exam_mark);
                        $('#editId').val(resp.id);

                        // Clear previous grade-items
                        $('.edit-repeat-group').empty();

                        // Loop through array fields and append inputs
                        const startMarks = resp.start_mark;
                        const endMarks = resp.end_mark;
                        const grades = resp.grade;
                        const gpas = resp.gpa;

                        if (startMarks.length) {
                            for (let i = 0; i < startMarks.length; i++) {
                                let html = `
                        <div class="row grade-item mt-2">
                            <div class="col-md-3">
                                <input type="text" name="start_markEdit[]" class="form-control start_markEdit" placeholder="Start mark" value="${startMarks[i]}" required>
                            </div>
                            <div class="col-md-3">
                                <input type="text" name="end_markEdit[]" class="form-control end_markEdit" placeholder="End mark" value="${endMarks[i]}" required>
                            </div>
                            <div class="col-md-3">
                                <input type="text" name="gradeEdit[]" class="form-control gradeEdit" placeholder="Grade" value="${grades[i]}" required>
                            </div>
                            <div class="col-md-2">
                                <input type="number" step="any" name="gpaEdit[]" class="form-control gpaEdit" placeholder="GPA" value="${gpas[i]}" required>
                            </div>
                            <div class="col-md-1">
                                <button type="button" class="btn btn-danger btn-sm remove-grade">×</button>
                            </div>
                        </div>`;
                                $('.edit-repeat-group').append(html);
                                console.log(html)
                            }
                        }


                        // Show modal
                        $('#editClass').modal('show');
                    }
                });
            });


            $('#update').on('click', function(event) {
                event.preventDefault();

                var id = $('#editId').val();
                var url = '{{ route('exam.wise.grade.update', ':id') }}'.replace(':id', id);

                // Arrays
                let startMarksEdit = [];
                let endMarksEdit = [];
                let gradesEdit = [];
                let gpasEdit = [];

                $('.start_markEdit').each(function() {
                    startMarksEdit.push($(this).val());
                });
                $('.end_markEdit').each(function() {
                    endMarksEdit.push($(this).val());
                });
                $('.gradeEdit').each(function() {
                    gradesEdit.push($(this).val());
                });
                $('.gpaEdit').each(function() {
                    gpasEdit.push($(this).val());
                });

                // Other fields
              
                var exam_id = $('#exam_idEdit').val();
                var session_id = $('#session_idEdit').val();
                var exam_mark = $('#exam_markEdit').val();

                $.ajax({
                    url: url,
                    type: 'GET',
                    data: {

                        
                        exam_id: exam_id,
                        session_id: session_id,
                        exam_mark: exam_mark,
                        start_mark: startMarksEdit,
                        end_mark: endMarksEdit,
                        grade: gradesEdit,
                        gpa: gpasEdit
                    },
                    success: function(data) {
                        if (data.success === true) {
                            toastr.success(data.message);
                            $('#data_table').DataTable().ajax.reload();
                            $('#editClass').modal('hide');
                        } else {
                            toastr.error(data.message);
                            $('#editClass').modal('show');
                        }
                    },
                    error: function(xhr) {
                        toastr.error('Update failed. Please check all fields.');
                    }
                });
            });


            $(document).ready(function() {
                var examid = $("#examId").val();
                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    responsive: true,
                    serverSide: true,
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "/exam-wise-grade/exam/" + examid,
                        type: "GET"
                    },
                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            orderable: false,
                            searchable: false
                        },

                      
                        {
                            data: 'exam',
                            name: 'exam'
                        },
                      
                        {
                            data: 'session',
                            name: 'session'
                        },
                        {
                            data: 'exam_mark',
                            name: 'exam_mark'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Grade List',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },

                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Grade List',
                            orientation: 'landscape',
                            pageSize: 'A2',
                            exportOptions: {
                                columns: ':visible'
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility'
                        }
                    ]
                });
            });

            $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                e.preventDefault();

                $.ajaxSetup({
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                    }
                });

                const url = $(this).data('remote');
                swal({
                    title: `Are you sure?`,
                    text: "Want to delete this record?",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: url,
                            type: 'get',
                            dataType: 'json',
                            data: {
                                submit: true,
                                _method: 'delete',
                                _token: "{{ csrf_token() }}"
                            }
                        }).always(function(data) {
                            $('#data_table').DataTable().ajax.reload();
                            if (data.success === true) {
                                toastr.success(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            } else {
                                toastr.error(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            }
                        });
                    }
                });
            });

            //  toastr.options.timeOut = 300;
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif



         

            $('#addMoreGrade').click(function() {
                let html = `
            <div class="row grade-item mt-2">
                <div class="col-md-3"><input type="text" name="start_mark[]" class="form-control start_mark" placeholder="Start mark" required></div>
                <div class="col-md-3"><input type="text" name="end_mark[]" class="form-control end_mark" placeholder="End mark" required></div>
                <div class="col-md-3"><input type="text" name="grade[]" class="form-control grade" placeholder="Grade" required></div>
                <div class="col-md-2"><input type="number" step="any" name="gpa[]" class="form-control gpa" placeholder="GPA" required></div>
                <div class="col-md-1"><button type="button" class="btn btn-danger btn-sm remove-grade">×</button></div>
            </div>`;
                $('.repeat-group').append(html);
            });
            $('#addMoreGradeEdit').click(function() {
                let html = `
        <div class="row grade-item mt-2">
            <div class="col-md-3"><input type="text" name="start_markEdit[]" class="form-control start_markEdit" placeholder="Start mark" required></div>
            <div class="col-md-3"><input type="text" name="end_markEdit[]" class="form-control end_markEdit" placeholder="End mark" required></div>
            <div class="col-md-3"><input type="text" name="gradeEdit[]" class="form-control gradeEdit" placeholder="Grade" required></div>
            <div class="col-md-2"><input type="number" step="any" name="gpaEdit[]" class="form-control gpaEdit" placeholder="GPA" required></div>
            <div class="col-md-1"><button type="button" class="btn btn-danger btn-sm remove-grade">×</button></div>
        </div>`;
                $('.edit-repeat-group').append(html);
            });


            $(document).on('click', '.remove-grade', function() {
                $(this).closest('.grade-item').remove();
            });
        </script>
    @endpush
@endsection
