@extends('dashboard.master')
@section('title', 'Help Line')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    {{-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=IBM+Plex+Sans:wght@400&display=swap" rel="stylesheet"> --}}
<style>

    /* @font-face {
            font-family: 'SolaimanLipi';
            src: url('{{ asset('fonts/SolaimanLipi_Bold_10-03-12.ttf') }}') format('truetype');
            font-weight: 800;
            font-style: normal;
            unicode-range: U+0980-09FF; 
        } */

        body {
              font-family: 'SolaimanLipi';
            src: url('{{ asset('fonts/SolaimanLipi_Bold_10-03-12.ttf') }}') format('truetype');
            font-weight: 800;
            font-style: normal;
            unicode-range: U+0980-09FF;
    font-size: 18px;
            /* font-weight: 600 */
           
        }

    a {
        text-decoration: none !important;
    }

    .info-card, .video-card {
        background: #fff;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
        margin-bottom: 20px;
        height: 100%;
        transition: 0.3s ease-in-out;
    }

    .info-label {
        font-weight: 600;
        font-size: 15px;
        margin-bottom: 5px;
        color: #333;
    }

    .info-value {
        font-size: 14px;
        color: #555;
        word-break: break-word;
    }

    .video-button {
        background-color: #00a99d;
        color: white !important;
        padding: 6px 14px;
        border-radius: 6px;
        text-decoration: none;
        display: inline-block;
        transition: 0.3s ease;
    }

    .video-button:hover {
        background-color: #00887a;
        color: #fff;
    }

    .video-title {
        font-size: 14px;
        font-weight: 500;
        margin-bottom: 10px;
        color: #222;
    }

    .video-card img {
        border-radius: 10px;
        width: 100%;
        height: 160px;
        object-fit: cover;
        margin-bottom: 12px;
    }

    .modal-content {
        border-radius: 15px;
        overflow: hidden;
    }

    @media (max-width: 767px) {
        .video-title {
            font-size: 13px;
        }
    }
</style>
@endpush

@section('content')
<div class="content-wrapper">
    <div class="container py-4">
        <!-- Info Cards -->
        <div class="row g-3 mb-4">

            <div class="col-md-4">
                <div class="info-card">
                    <div class="info-label" > WhatsApp</div>
                    <div class="info-value">
                        <a class="video-button" target="_blank" href="https://wa.me/{{ str_replace(['+', '-', ' '], '', '01804909500') }}">Chat Now</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-card">
                    <div class="info-label">Facebook</div>
                    <div class="info-value">
                        {{-- @dd($data) --}}
                        <a class="video-button" target="_blank" href="https://www.facebook.com/sabaqapp">Visit</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-card">
                    <div class="info-label">YouTube</div>
                    <div class="info-value">
                        <a class="video-button" target="_blank" href="https://www.youtube.com/@sabaqapp">Visit</a>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-card">
                    <div class="info-label">Phone</div>
                    <div class="info-value">01804909500</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-card">
                    <div class="info-label">Email</div>
                    <div class="info-value">sabaq@gmail.com</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-card">
                    <div class="info-label">Address</div>
                    <div class="info-value">Level-4, Titash Tower, Moulovipara Brahmanbaria-3400</div>
                </div>
            </div>
        </div>

        <!-- Video Grid -->
        <div class="row g-3">
            @php
                $videos = [
                    
                    'বেফাকুল মাদারিসের সম্পূর্ণ ব্যবহার শিখুন' => 'K4yGpnRyWTY',
                    'ড্যাশবোর্ড ফিচার গাইড' => 'P4Ni2aYBe0o',
                    'সিস্টেম সেটিংস কনফিগারেশন' => '-2d2_NZodIY',
                    'শিক্ষার্থী ব্যবস্থাপনা' => 'TRumB--cyKA',
                    'একাডেমিক বিভাগ পরিচালনা' => 'd3JX8AMKdMU',
                    'শিক্ষক ব্যবস্থাপনা' => 'l6nVucuHZXY',
                    'প্রশাসনিক বিভাগ পরিচালনা' => 'srRaYtiNNv4',
                    'হিসাব ও অর্থ বিভাগ পরিচালনা' => 'DY0OlogZI6o',
                    'রশিদ ব্যবস্থাপনা' => 'hB1XL2hQKaM',
                    'স্পনসর ও অনুদান বিভাগ পরিচালনা' => 'Siihw_eSqV8',
                    'ঋণ ও বাকি ব্যবস্থাপনা' => '1z-SjAmwtBw',
                    'এতিম স্পনসর বিভাগ' => 'Owbj17u9Hb4',
                    'বোর্ডিং ব্যবস্থাপনা' => 'CNQeHQ42ojs',
                    'নোটিশ ও ঘোষণাপত্র' => '7CDUBla-34A',
                ];
            @endphp

            @foreach($videos as $title => $videoId)
                <div class="col-sm-6 col-md-4 col-lg-3">
                    <div class="video-card h-100 d-flex flex-column justify-content-between">
                        <img src="https://img.youtube.com/vi/{{ $videoId }}/hqdefault.jpg" alt="Thumbnail">
                        <div class="video-title">{{ $title }}</div>
                        <a href="#" class="video-button mt-auto play-video" data-video="https://www.youtube.com/embed/{{ $videoId }}">▶ ভিডিও দেখুন</a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

<!-- YouTube Modal -->
<div class="modal fade" id="youtubeModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body p-0">
                <div class="ratio ratio-16x9">
                    <iframe id="youtubeIframe" class="w-100" src="" title="YouTube video" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
@if(Session::has('success'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true,
        "timeOut": 2000
    };
    toastr.success("{{ session('success') }}");
@endif

@if(Session::has('error'))
    toastr.options = {
        "closeButton": true,
        "progressBar": true
    };
    toastr.error("{{ session('error') }}");
@endif

// Play video in modal
$(document).on('click', '.play-video', function(e) {
    e.preventDefault();
    const videoSrc = $(this).data("video") + "?autoplay=1";
    $("#youtubeIframe").attr("src", videoSrc);
    $("#youtubeModal").modal("show");
});

// Stop video when modal is closed
$('#youtubeModal').on('hide.bs.modal', function () {
    $("#youtubeIframe").attr("src", "");
});
</script>
@endpush
