@extends('dashboard.master')
@section('title', 'Invoice Design')
@push('css')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css"
        integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }

        .dropify-wrapper .dropify-preview img {
            /* object-fit: cover; */
            width: 100%;
            height: 100%;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Invoice Design</b>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">
                        <form enctype="multipart/form-data" action="{{ route('invoice.design.store') }}" method="POST">
                            @csrf
                            <input type="hidden" name="id" value="{{ isset($data) ? $data->id : '' }}">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="invoice_bg">প্রিন্টে ব্যবহৃত ব্যাকগ্রাউন্ড</label>
                                        <input type="file" name="invoice_bg" id="invoice_bg"
                                            data-height="150"
                                            @if ($data) data-default-file="{{ asset('img/' . $data->invoice_bg) }}" @endif
                                            class="dropify form-control">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="invoice_header">প্রিন্টে ব্যবহৃত হেডার</label>
                                        <input type="file" name="invoice_header" id="invoice_header" data-height="150"
                                            @if ($data) data-default-file="{{ asset('img/' . $data->invoice_header) }}" @endif
                                            class="dropify form-control">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="invoice_footer">প্রিন্টে ব্যবহৃত ফুটার</label>
                                        <input type="file" name="invoice_footer" id="invoice_footer" data-height="150"
                                            @if ($data) data-default-file="{{ asset('img/' . $data->invoice_footer) }}" @endif
                                            class="dropify form-control">
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-30">
                                @if(auth()->user()->canPerm('invoice_design.update') || auth()->user()->type == '1' || auth()->user()->role_id == '1')
                                <div class="col-sm-12">
                                    <button title="Create Button" type="submit"
                                        class="btn btn-success mr-2">{{ isset($data) ? 'Update' : 'Save' }}</button>
                                </div>
                                @endif
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js"
            integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script>
            $(document).ready(function() {
                $('.dropify').dropify();
            });
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
