@extends('dashboard.master')
@section('title', 'Notice Send')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Notice Send</b>
					</span>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">

                    <form enctype="multipart/form-data" action="{{ route('group.notice.store') }}" method="POST">
                        @csrf

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="student_id">Student</label>
                                    <textarea name="student_text" id="student_text" class="form-control" cols="3" rows="3" placeholder="write text here..."></textarea>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="teacher_id">Teacher</label>
                                    <textarea name="teacher_text" id="teacher_text" class="form-control" cols="3" rows="3" placeholder="write text here..."></textarea>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="donar_id">Donar</label>
                                    <textarea name="donar_text" id="donar_text" class="form-control" cols="3" rows="3" placeholder="write text here..."></textarea>
                                </div>
                            </div>

                        </div>

                        <div class="row mt-30">
                            <div class="col-sm-12">
                                <button title="Create Button" type="submit" class="btn btn-success mr-2">Send</button>
                            </div>
                        </div>

                    </form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection



