@extends('dashboard.master')
@section('title', 'Notice Edit')
@push('css')

<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.css" rel="stylesheet">

@endpush

@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Notice Edit</b>
					</span>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('notice.update', $data->id) }}" method="POST">
                        @csrf
                        @method('put')

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="title">Title<span class="text-red">*</span></label>
                                    <textarea name="title" class="form-control" rows="2" placeholder="Write title..." required>{{ $data->title }}</textarea>

                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="notice">Notice<span class="text-red">*</span></label>
                                    <textarea name="notice" id="notice" class="form-control" rows="10" placeholder="Write notice..." required>{{ $data->notice }}</textarea>
                                </div>
                            </div>

                        </div>

                        <div class="row mt-2">
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-success mr-2">Update</button>
                            </div>
                        </div>

                    </form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.9.0/dist/summernote.min.js"></script>
<script>
$(document).ready(function () {
    $('#notice').summernote({
    height: 300,
    popover: {
        image: [],    // remove image popover
        link: [],     // (optional) remove link popover if needed
        air: []       // (optional) remove air popover if needed
    },
    toolbar: [
        // শুধুমাত্র প্রয়োজনীয় toolbar রাখুন
        ['style', ['bold', 'italic', 'underline', 'clear']],
        ['font', ['strikethrough', 'superscript', 'subscript']],
        ['fontsize', ['fontsize']],
        ['color', ['color']],
        ['para', ['ul', 'ol', 'paragraph']],
        ['height', ['height']]
        // intentionally skipping ['insert', ['picture', 'video', 'link', 'table', 'hr']] 
    ],
    callbacks: {
        onPaste: function (e) {
            // prevent image paste
            var clipboardData = e.originalEvent.clipboardData;
            if (clipboardData && clipboardData.items) {
                for (var i = 0; i < clipboardData.items.length; i++) {
                    if (clipboardData.items[i].type.indexOf("image") !== -1) {
                        e.preventDefault();
                        return;
                    }
                }
            }
        }
    }
});

});
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection



