@extends('dashboard.master')
@section('title', 'Notice Print')
<?php

$invoiceBgPath = 'back_height.jpg';

if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
    $potentialBgFile = 'img/' . $invoice->invoice_bg;
    if (file_exists(public_path($potentialBgFile))) {
        $invoiceBgPath = $potentialBgFile;
    }
}
?>
@push('css')
    <style>
        @media print {
            @page {
                size: A4;
                margin: 20mm;
            }

            html,
            body {
                margin: 0;
                padding: 0;
                width: 210mm;
                height: 297mm;

            }

            body * {
                visibility: hidden;
            }

            #print-container,
            #print-container * {
                visibility: visible;

            }

            #print-container {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                display: flex !important;
                flex-direction: column;
                justify-content: space-between;
                box-sizing: border-box;
                padding: 0;


            }

            #printButton,
            .page-title-wrapper,
            .content-header,
            .text-right {
                display: none !important;
            }

            #notice-content {
                display: none !important;
            }

            .printed-notice {
                display: block !important;
                flex: 1;
                white-space: pre-wrap;
                padding: 10px;
                font-size: 16px;
                margin: 0 20px 20px 20px;
                box-sizing: border-box;
                overflow-wrap: break-word;
                border: none !important;
            }

            #footer-img {
                margin-top: auto;
                width: 100%;
            }

            .footer-on-screen {
                display: block !important;
            }

            .printArea {
                background-image: url('{{ asset($invoiceBgPath) }}') !important;
                background-size: cover !important;
                background-position: center !important;
                background-repeat: no-repeat ;
            }
        }

        .printed-notice {
            display: none;
        }

        .printArea p {
            padding: 20px
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper d-flex justify-content-between align-items-center">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span><b>Notice Print</b></span>
                    </div>
                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i> Back
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body">

                        <div class="printArea" id="print-container">
                            <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                                style="width:100%; height:150px; margin-bottom:30px;">

                            <th class="notice-text">{!! $data->notice ?? '' !!}</th>

                            <div id="footer-img" class="footer-on-screen">
                                <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer"
                                    style="width:100%; height:150px;">
                            </div>
                        </div>
                    </div>

                    <div class="text-right pr-4 pb-3">
                        <button title="a4 page" id="printButton" class="btn btn-primary mb-2">Print</button>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('js')
    <script>
        $('#printButton').on('click', function() {
            var noticeText = $('#notice-content').val();
            var printContents = $('.printArea').clone();

            printContents.find('#notice-content').replaceWith(
                '<div class="printed-notice">' +
                noticeText +
                '</div>'
            );

            var originalContents = $('body').html();
            $('body').html(printContents);
            window.print();
            $('body').html(originalContents);
            location.reload();
        });
    </script>
@endpush
