@extends('dashboard.master')
@section('title', 'Assign Permissions')

@push('css')
    {{-- DataTables --}}
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <style>
        .perm-chip {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: .25rem .5rem;
            border: 1px solid #e5e7eb;
            border-radius: 999px;
            margin: 3px;
            background: #f9fafb;
            font-size: 12px;
        }

        .module-card {
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            padding: 12px;
            margin-bottom: 16px;
        }

        .module-head {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
        }

        .sticky-actions {
            position: sticky;
            top: 64px;
            z-index: 5;
        }
    </style>
@endpush

@section('content')
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="page-title-heading">
                        <div class="page-title-icon"><i class="nav-icon fas fa-key"></i></div>
                        <span><b>Assign Permissions</b> — Role: {{ $role->name }}</span>
                    </div>
                    <div class="sticky-actions">
                        <button class="btn btn-outline-secondary btn-sm me-2" id="btnSelectAll">
                            <i class="fa fa-check-square"></i> Select All
                        </button>
                        <button class="btn btn-outline-secondary btn-sm me-2" id="btnUnselectAll">
                            <i class="fa fa-square"></i> Unselect All
                        </button>
                        <button class="btn btn-primary btn-sm" id="btnSavePerms">
                            <i class="fa fa-save"></i> Save
                        </button>
                        <a href="{{ route('user.role.index') }}" class="btn btn-light btn-sm ms-2">Back</a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">

                {{-- Search + Count --}}
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="row g-2 align-items-center">
                            <div class="col-md-4">
                                <input type="text" id="searchBox" class="form-control"
                                    placeholder="Search permission or module...">
                            </div>
                            <div class="col-md-8 text-end">
                                <span class="badge bg-info">Checked: <span id="checkedCount">0</span></span>
                                <span class="badge bg-secondary ms-2">Total: <span id="totalCount">0</span></span>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Permissions Form --}}
                <form id="permForm" method="POST" action="{{ route('user.role.perms.store', $role) }}">
                    @csrf

                    {{-- DataTables-like container (we'll fake it with client-side filter) --}}
                    <div id="modulesWrap">
                        @forelse ($permissions as $module => $perms)
                            <div class="module-card" data-module="{{ strtolower($module) }}">
                                <div class="module-head">
                                    <h6 class="mb-0">
                                        <i class="fa fa-box me-1"></i>
                                        <span class="text-uppercase">{{ $module }}</span>
                                        <small class="text-muted ms-2">({{ $perms->count() }})</small>
                                    </h6>
                                    <div>
                                        <label class="me-2 small">
                                            <input type="checkbox" class="module-toggle form-check-input me-1">
                                            Toggle this module
                                        </label>
                                    </div>
                                </div>
                                <div class="module-body">
                                    <div class="row">
                                        @foreach ($perms as $p)
                                            <div class="col-md-4">
                                                <label class="perm-chip"
                                                    data-text="{{ strtolower($module . ' ' . $p->name . ' ' . $p->key) }}">
                                                    <input type="checkbox" class="perm-check form-check-input"
                                                        name="permissions[]" value="{{ $p->id }}"
                                                        {{ in_array($p->id, $rolePerms) ? 'checked' : '' }}>
                                                    <span class="text-muted">{{ $p->key }}</span>
                                                    <span>— {{ $p->name }}</span>
                                                </label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="alert alert-warning">No permissions defined.</div>
                        @endforelse
                    </div>
                </form>

            </div>
        </section>
    </div>
@endsection

@push('js')
    {{-- jQuery + Bootstrap (থাকলে ডুপ্লিকেট কোরো না) --}}
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    {{-- Toastr --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>

    <script>
        $(function() {
            // Count init
            function refreshCounts() {
                $('#totalCount').text($('.perm-check').length);
                $('#checkedCount').text($('.perm-check:checked').length);
            }
            refreshCounts();

            // Select All / Unselect All
            $('#btnSelectAll').on('click', function() {
                $('.perm-check:visible').prop('checked', true);
                refreshCounts();
            });
            $('#btnUnselectAll').on('click', function() {
                $('.perm-check:visible').prop('checked', false);
                refreshCounts();
            });

            // Per-module toggle (checkbox toggles all in this module)
            $(document).on('change', '.module-toggle', function() {
                const card = $(this).closest('.module-card');
                const isChecked = $(this).is(':checked');
                card.find('.perm-check:visible').prop('checked', isChecked);
                refreshCounts();
            });

            // update count on single click
            $(document).on('change', '.perm-check', refreshCounts);

            // Client-side filter (module + key + name)
            $('#searchBox').on('input', function() {
                const q = $(this).val().toLowerCase().trim();
                if (!q) {
                    $('.module-card').show();
                    $('.perm-chip').show();
                    return;
                }
                // Hide all; then show matched
                $('.perm-chip').each(function() {
                    const t = $(this).data('text');
                    $(this).toggle(t.indexOf(q) !== -1);
                });

                // Hide module-card if no chip visible inside it
                $('.module-card').each(function() {
                    const hasVisible = $(this).find('.perm-chip:visible').length > 0;
                    $(this).toggle(hasVisible);
                });
            });

            // Save
            $('#btnSavePerms').on('click', function() {
                const $form = $('#permForm');
                const url = $form.attr('action');
                const data = $form.serialize();
                // console.log(data);

                $.post(url, data)
                    .done(function(res) {
                        console.log('res', res);
                        alert(res.message ?? 'Updated');
                        toastr.success(res.message ?? 'Updated');
                    })
                    .fail(function(xhr) {
                        toastr.error('Failed to update permissions');
                    });
            });

            // Toastr flash (optional)
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };
                toastr.success("{{ session('success') }}");
            @endif
            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        });
    </script>
@endpush
