@extends('dashboard.master')
@section('title', 'Licence')

@push('css')
  {{-- DataTables CSS --}}
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <div class="page-title-wrapper">
        <div class="page-title-heading">
          <div class="page-title-icon">
            <i class="nav-icon fas fa-mosque"></i>
          </div>
          <span><b>ইউজার রোল</b></span>
        </div>
      </div>
    </div>
  </div>

  <section class="content">
    <div class="container-fluid">

      <div class="card">
        <div class="card-body">

          <div class="d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0">Roles</h4>
            <button type="button" class="btn btn-primary openCreateRoleModal">
              <i class="fa fa-plus"></i> New Role
            </button>
          </div>

          <div class="card">
            <div class="card-body">
              <table id="rolesTable" class="table table-bordered table-striped w-100">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Name</th>
                    {{-- <th>Created At</th> --}}
                    <th width="220">Actions</th>
                  </tr>
                </thead>
              </table>
            </div>
          </div>

        </div>

        {{-- Create Modal --}}
        <div class="modal fade" id="createRoleModal" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog">
            <form id="createRoleForm" class="modal-content" method="POST" action="{{ route('user.role.store') }}">
              @csrf
              <div class="modal-header">
                <h5 class="modal-title">Create Role</h5>
                <button type="button" class="btn-close closeCreateRoleModal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <div class="mb-3">
                  <label class="form-label">Role Name</label>
                  <input type="text" class="form-control" name="name" placeholder="Role name" required>
                </div>
                <div class="text-danger small d-none" id="createErrors"></div>
              </div>
              <div class="modal-footer">
                <button class="btn btn-secondary closeCreateRoleModal" type="button">Close</button>
                <button class="btn btn-primary" type="submit">Save</button>
              </div>
            </form>
          </div>
        </div>

        {{-- Edit Modal --}}
        <div class="modal fade" id="editRoleModal" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog">
            <form id="editRoleForm" class="modal-content" method="POST">
              @csrf @method('PUT')
              <div class="modal-header">
                <h5 class="modal-title">Edit Role</h5>
                <button type="button" class="btn-close closeEditRoleModal" aria-label="Close"></button>
              </div>
              <div class="modal-body">
                <div class="mb-3">
                  <label class="form-label">Role Name</label>
                  <input type="text" id="editRoleName" name="name" class="form-control" required>
                </div>
                <div class="text-danger small d-none" id="editErrors"></div>
              </div>
              <div class="modal-footer">
                <button class="btn btn-secondary closeEditRoleModal" type="button">Close</button>
                <button class="btn btn-primary" type="submit">Update</button>
              </div>
            </form>
          </div>
        </div>

      </div>

    </div>
  </section>
</div>
@endsection

@push('js')
  {{-- jQuery (থাকলে ডুপ্লিকেট কোরো না) --}}
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

  {{-- Bootstrap JS (master-এ থাকলে বাদ দিতে পারো) --}}
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  {{-- DataTables JS --}}
  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

  {{-- Toastr --}}
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>

  <script>
  $(function () {
      // CSRF setup for AJAX
      $.ajaxSetup({
          headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')}
      });

      // Init DataTable
      const table = $('#rolesTable').DataTable({
          processing: true,
          serverSide: true,
          ajax: "{{ route('user.role.index') }}",
          order: [[2, 'desc']],
          columns: [
              {data: 'DT_RowIndex', name: 'DT_RowIndex', orderable:false, searchable:false},
              {data: 'name', name: 'name'},
              // {data: 'created_at', name: 'created_at'},
              {data: 'actions', name: 'actions', orderable:false, searchable:false}
          ]
      });

      // ===== Modal open/close via jQuery =====
      // Create open
      $(document).on('click', '.openCreateRoleModal', function() {
          $('#createErrors').addClass('d-none').empty();
          $('#createRoleForm')[0].reset();
          $('#createRoleModal').modal('show');
      });
      // Create close
      $(document).on('click', '.closeCreateRoleModal', function() {
          $('#createRoleModal').modal('hide');
      });

      // Edit open (fill data)
      $(document).on('click', '.editRoleBtn', function() {
          const name   = $(this).data('name');
          const action = $(this).data('action');
          $('#editErrors').addClass('d-none').empty();
          $('#editRoleName').val(name);
          $('#editRoleForm').attr('action', action);
          $('#editRoleModal').modal('show');
      });
      // Edit close
      $(document).on('click', '.closeEditRoleModal', function() {
          $('#editRoleModal').modal('hide');
      });

      // ===== AJAX submit =====
      // Create submit (AJAX)
      $('#createRoleForm').on('submit', function(e) {
          e.preventDefault();
          const $form = $(this);
          const url   = $form.attr('action');
          const data  = $form.serialize();

          $.post(url, data)
              .done(function(res) {
                  toastr.success(res.message ?? 'Role created');
                  $('#createRoleModal').modal('hide');
                  table.ajax.reload(null, false);
              })
              .fail(function(xhr) {
                  const err = xhr.responseJSON?.errors || {};
                  let html = '';
                  Object.keys(err).forEach(k => html += '<div>• '+ err[k][0] +'</div>');
                  if (!html) html = 'Something went wrong';
                  $('#createErrors').removeClass('d-none').html(html);
              });
      });

      // Edit submit (AJAX)
      $('#editRoleForm').on('submit', function(e) {
          e.preventDefault();
          const $form = $(this);
          const url   = $form.attr('action');
          const data  = $form.serialize();

          $.ajax({url, method: 'POST', data})
              .done(function(res) {
                  toastr.success(res.message ?? 'Role updated');
                  $('#editRoleModal').modal('hide');
                  table.ajax.reload(null, false);
              })
              .fail(function(xhr) {
                  const err = xhr.responseJSON?.errors || {};
                  let html = '';
                  Object.keys(err).forEach(k => html += '<div>• '+ err[k][0] +'</div>');
                  if (!html) html = 'Something went wrong';
                  $('#editErrors').removeClass('d-none').html(html);
              });
      });

      // Toastr (flash)
      @if (Session::has('success'))
        toastr.options = {"closeButton": true, "progressBar": true, "timeOut": 2000};
        toastr.success("{{ session('success') }}");
      @endif
      @if (Session::has('error'))
        toastr.options = {"closeButton": true, "progressBar": true};
        toastr.error("{{ session('error') }}");
      @endif
  });
  </script>
@endpush
