@extends('dashboard.master')
@section('title', 'Notice Send')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<style>
.select2-container .select2-selection--single {
    height: 36px;
}
</style>
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Notice Send</b></span>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form class="" enctype="multipart/form-data" action="{{ route('single.notice.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="type">Notice Send</label>
                                    <select name="type" id="type" class="form-control">
                                        <option value="">Select One</option>
                                        <option value="1">Student</option>
                                        <option value="2">Teacher</option>
                                        <option value="3">Donar</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6 session_id hideClass">
                                <div class="form-group">
                                    <label for="session_id">Session</label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach($sessions as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6 class_id hideClass">
                                <div class="form-group">
                                    <label for="class_id">Class</label>
                                    <select name="class_id" id="class_id" class="form-control" style="height: 35px;">
                                        <option value="">Select Class</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6 student_id hideClass">
                                <div class="form-group">
                                    <label for="student_id">Student</label>
                                    <select name="student_id" id="student_id" class="form-control" style="height: 35px !important;">
                                        <option value="">Select Student</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6 teacher_id hideClass">
                                <div class="form-group">
                                    <label for="teacher_id">Teacher</label>
                                    <select name="teacher_id" id="teacher_id" class="form-control">
                                        <option value="">Select Teacher</option>
                                        @foreach($teachers as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6 donar_id hideClass">
                                <div class="form-group">
                                    <label for="donar_id">Donar</label>
                                    <select name="donar_id" id="donar_id" class="form-control" style="height: 35px !important;">
                                        <option value="">Select Donar</option>
                                        @foreach($donars as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-12 notice hideClass">
                                <div class="form-group">
                                    <label for="notice">Notice</label>
                                    <textarea name="notice" id="notice" class="form-control" cols="3" rows="3" placeholder="write notice here..." required></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-30 hideClass sendbtn">
                            <div class="col-sm-12">
                                <button title="Create Button" type="submit" class="btn btn-success mr-2">Send</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script>
$('.hideClass').hide();
$(document).ready(function() {
    $('#donar_id').select2();
    $('#student_id').select2();
    $('#teacher_id').select2();

    $('#type').on('change', function(event) {
        event.preventDefault();
        const type = $(this).val();
        $('.hideClass').hide();

        if (type == 1) {
            $('.session_id').show();
            $('.class_id').show();
            $('.student_id').show();
            $('.notice').show();
            $('.sendbtn').show();
            $('.teacher_id').hide();
            $('.donar_id').hide();
            $('#donar_id').val(null).trigger('change');
            $('#teacher_id').val(null).trigger('change');
        } else if (type == 2) {
            $('#student_id').val(null).trigger('change');
            $('#donar_id').val(null).trigger('change');
            $('.teacher_id').show();
            $('.notice').show();
            $('.sendbtn').show();
            $('.session_id').hide();
            $('.class_id').hide();
            $('.student_id').hide();
            $('.donar_id').hide();
        } else if (type == 3) {
            $('#student_id').val(null).trigger('change');
            $('#teacher_id').val(null).trigger('change');
            $('.donar_id').show();
            $('.notice').show();
            $('.sendbtn').show();
            $('.session_id').hide();
            $('.class_id').hide();
            $('.student_id').hide();
            $('.teacher_id').hide();
        } else {
            $('.hideClass').hide();
        }

        $('#donar_id').select2();
        $('#student_id').select2();
        $('#teacher_id').select2();
    });
});


$(document).ready(function() {
    $('#session_id').on('change', function(event) {
        event.preventDefault();

        var url = "{{ route('session.wise.class') }}";
        var session_id = $('#session_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');

        $('#class_id').empty().append('<option value="">Choose One</option>');

        if (session_id) {
            $.ajax({
                url: url,
                type: "POST",
                data: {
                    session_id: session_id,
                    _token: _token,
                },
                success: function(response) {
                    if (response.length > 0) {
                        $.each(response, function(index, record) {
                            $('#class_id').append(
                                '<option value="' + record.class_id + '">' + record.stuclass.name +'</option>'
                            );
                        });
                    } else {
                        $('#class_id').val(null).trigger('change');
                        $('#student_id').val(null).trigger('change');
                        alert('No class found for this session.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert("An error occurred while processing the request.");
                }
            });
        }
    });
});

$(document).ready(function() {
    $('#class_id').on('change', function(event) {
        event.preventDefault();

        var url = "{{ route('class.wise.student') }}";
        var class_id = $('#class_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');

        $('#student_id').empty().append('<option value="">Choose One</option>');

        if (class_id) {
            $.ajax({
                url: url,
                type: "POST",
                data: {
                    class_id: class_id,
                    _token: _token,
                },
                success: function(response) {
                    if (response.length > 0) {
                        $.each(response, function(index, student) {
                            $('#student_id').append(
                                '<option value="' + student.id + '">' + student.name + ' || ' + student.register_no + ' || ' + student.roll_no + '</option>'
                            );
                        });
                    } else {
                        $('#student_id').val(null).trigger('change');
                        alert('No students found for this class.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    alert("An error occurred while processing the request.");
                }
            });
        }
    });
});

@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };
    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
