@extends('dashboard.master')
@section('title', 'SMS Status')
@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
<style>
.form-check-input {
    height: 20px;
    width: 20px;
    margin-right: 5px;
    margin-top: 13px;
}
.form-check-label {
    vertical-align: middle;
    margin-left: 10px;
    margin-top: 10px;

}
</style>
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>SMS Status</b>
					</span>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">

                    <form enctype="multipart/form-data" action="{{ route('sms.status.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" value="{{ isset($data) ? $data->id : ' ' }}">
                        <div class="row">

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_admission" value="1"  {{ isset($data) && $data->student_admission ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী ভর্তি</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_payment" value="1"  {{ isset($data) && $data->student_payment ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী বেতন</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_attendance" value="1"  {{ isset($data) && $data->student_attendance ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী হাজিরা</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_leave" value="1"  {{ isset($data) && $data->student_leave ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী ছুটি</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_deactivate" value="1"  {{ isset($data) && $data->student_deactivate ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী নিষ্ক্রিয়</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_comment" value="1"  {{ isset($data) && $data->student_comment ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী পরীক্ষার মন্তব্য</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_sonad" value="1"  {{ isset($data) && $data->student_sonad ? 'checked' : '' }}>
                                    <label class="form-check-label">পরীক্ষার সনদ</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_admitcard" value="1"  {{ isset($data) && $data->student_admitcard ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী প্রবেশপত্র</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_result" value="1"  {{ isset($data) && $data->student_result ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষার্থী পরীক্ষার ফলাফল</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="student_sponsor" value="1"  {{ isset($data) && $data->student_sponsor ? 'checked' : '' }}>
                                    <label class="form-check-label">এতিম স্পনসর</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="teacher_admission" value="1"  {{ isset($data) && $data->teacher_admission ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষক নিয়োগ</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="teacher_attendance" value="1"  {{ isset($data) && $data->teacher_attendance ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষক হাজিরা</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="teacher_leave" value="1"  {{ isset($data) && $data->teacher_leave ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষক ছুটি</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="teacher_salary" value="1"  {{ isset($data) && $data->teacher_salary ? 'checked' : '' }}>
                                    <label class="form-check-label">শিক্ষক বেতন-ভাতা</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="donar_admission" value="1"  {{ isset($data) && $data->donar_admission ? 'checked' : '' }}>
                                    <label class="form-check-label">দাতা</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="donation" value="1"  {{ isset($data) && $data->donation ? 'checked' : '' }}>
                                    <label class="form-check-label">অনুদান</label>
                                  </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="check1" name="donar_payment" value="1"  {{ isset($data) && $data->donar_payment ? 'checked' : '' }}>
                                    <label class="form-check-label">স্পনসর পেমেন্ট</label>
                                  </div>
                            </div>

                        </div>

                        <div class="row mt-30" style="margin-top: 30px;">
                            <div class="col-sm-12">
                                <button title="Save" type="submit" class="btn btn-success mr-2">Save</button>
                            </div>
                        </div>

                    </form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
@if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 2000
    };

    toastr.success("{{ session('success') }}");
@endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection



