@extends('dashboard.master')
@section('title', 'Subject Assign')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Subject Assign</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
                    <a title="a4 print" id="printButton" type="button" class="btn btn-sm btn-danger" >
                        <i class="fas fa-file mr-1"></i>
                        Print
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body printArea">
                    <img id="header-img" src="{{ asset('img/' . $design->invoice_header) }}" alt="Header" style="width:100%; height:150px; margin-bottom:20px;">
                    <div class="row">
                        <div class="col-6">
                            <h5>Class : {{$data->stuclass->name ?? ''}}</h5>
                        </div>
                        <div class="col-6 text-right">
                            <p><strong>Print Date:</strong> {{ now()->format('d/m/Y') }}</p>
                        </div>
                    </div>
					<table id="data_table" class="table table-bordered table-striped data-table table-hover" >
                        <thead>
                            <tr>
                                <th class="text-left">SN</th>
                                <th class="text-right">Subject</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($subjects as $key => $subject)
                            <tr>
                                <td class="text-left">{{ $loop->iteration }}</td>
                                <td class="text-right">{{ $subject->subjects->name ?? '' }}</td>
                            </tr>
                           @endforeach
                        </tbody>
                    </table>
                    <div id="footer-img">
                        <img src="{{ asset('img/' . $design->invoice_footer) }}" alt="Footer" style="width:100%; height:150px; margin-top:20px;">
                    </div>

				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script>
    $('#printButton').on('click', function () {
        var printContents = $('.printArea').html();
        var originalContents = $('body').html();

        $('body').html(printContents);
        window.print();

        $('body').html(originalContents);
        location.reload();
    });
</script>
@endpush
@endsection
