@extends('dashboard.master')
@section('title', 'Create Table')

@push('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span><b>Create Table</b></span>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('create.table.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Table Type<span class="text-red">*</span></label>
                                <select id="table_type" class="form-control" required>
                                    <option value="new">New Table</option>
                                    <option value="existing">Existing Table</option>
                                </select>
                            </div>
                            <div class="mb-3 col-md-6" id="new_table_div">
                                <label class="form-label">Table Name<span class="text-red">*</span></label>
                                <input type="text" id="table_name" name="table_name" class="form-control" placeholder="Enter table name">
                            </div>
                            <div class="mb-3 col-md-6 d-none" id="existing_table_div">
                                <label class="form-label">Select Table<span class="text-red">*</span></label>
                                <select name="table_name" id="existing_table_select" class="form-control">
                                    <option value="">Select a table</option>
                                    @foreach($tables as $table)
                                        <option value="{{ $table }}">{{ $table }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Field Name<span class="text-red">*</span></label>
                                <input type="text" name="fields[0][name]" class="form-control" required>
                            </div>
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Field Type<span class="text-red">*</span></label>
                                <div class="d-flex">
                                    <select name="fields[0][type]" class="form-control" required>
                                        <option value="string">String</option>
                                        <option value="integer">Integer</option>
                                        <option value="bigInteger">Big Integer</option>
                                        <option value="boolean">Boolean</option>
                                        <option value="text">Text</option>
                                        <option value="longText">Long Text</option>
                                        <option value="date">Date</option>
                                        <option value="datetime">Datetime</option>
                                        <option value="time">Time</option>
                                        <option value="timestamp">Timestamp</option>
                                        <option value="float">Float</option>
                                        <option value="decimal">Decimal</option>
                                        <option value="double">Double</option>
                                        <option value="binary">Binary</option>
                                        <option value="json">JSON</option>
                                    </select>
                                    <button type="button" class="btn btn-primary ms-2" onclick="addField()">+</button>
                                </div>
                            </div>
                        </div>
                        <div id="fields"></div>
                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-success">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
    let fieldIndex = 1;

    function addField() {
        let fieldsDiv = document.getElementById('fields');
        let newField = `
            <div class="row mb-3 align-items-center" id="fieldRow-${fieldIndex}">
                <div class="col-md-6">
                    <input type="text" name="fields[${fieldIndex}][name]" class="form-control" required>
                </div>
                <div class="col-md-6">
                    <div class="d-flex">
                        <select name="fields[${fieldIndex}][type]" class="form-control" required>
                            <option value="string">String</option>
                            <option value="integer">Integer</option>
                            <option value="bigInteger">Big Integer</option>
                            <option value="boolean">Boolean</option>
                            <option value="text">Text</option>
                            <option value="longText">Long Text</option>
                            <option value="date">Date</option>
                            <option value="datetime">Datetime</option>
                            <option value="time">Time</option>
                            <option value="timestamp">Timestamp</option>
                            <option value="float">Float</option>
                            <option value="decimal">Decimal</option>
                            <option value="double">Double</option>
                            <option value="binary">Binary</option>
                            <option value="json">JSON</option>
                        </select>
                        <button type="button" class="btn btn-danger ms-2" onclick="removeField(${fieldIndex})">-</button>
                    </div>
                </div>
            </div>
        `;
        fieldsDiv.insertAdjacentHTML('beforeend', newField);
        fieldIndex++;
    }

    function removeField(index) {
        document.getElementById(`fieldRow-${index}`).remove();
    }

    document.getElementById('table_type').addEventListener('change', function() {
        let newTableInput = document.getElementById('table_name');
        let existingTableSelect = document.getElementById('existing_table_select');

        if (this.value === 'new') {
            document.getElementById('new_table_div').classList.remove('d-none');
            document.getElementById('existing_table_div').classList.add('d-none');
            newTableInput.setAttribute('required', 'true');
            existingTableSelect.removeAttribute('required');
        } else {
            document.getElementById('new_table_div').classList.add('d-none');
            document.getElementById('existing_table_div').classList.remove('d-none');
            newTableInput.removeAttribute('required');
            existingTableSelect.setAttribute('required', 'true');
        }
    });

    @if(Session::has('success'))
        toastr.success("{{ session('success') }}");
    @endif

    @if(Session::has('error'))
        toastr.error("{{ session('error') }}");
    @endif
</script>
@endpush
@endsection
