@extends('dashboard.master')
@section('title', 'Staff Salary Increment')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Staff Salary Increment</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ route('salary-increment.index') }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('staff-salary-increment.store') }}" method="POST">
                        @csrf
                        <div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="staff_id">Staff ID<span class="text-red">*</span></label>
									<input type="text" name="staff_user_id" value="{{ $data->staff_user_id }}" class="form-control" readonly>
									<input type="hidden" name="staff_id" id="staff_id" value="{{ $data->id }}" class="form-control" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name">Staff Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="salary">Previous Salary <span class="text-red">*</span></label>
									<input type="text" name="previous_salary" id="previous_salary" value="{{ $data->salary }}" class="form-control salary" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="current_salary">Current Salary <span class="text-red">*</span></label>
									<input type="text" name="current_salary" id="current_salary" value="{{ $data->salary }}" class="form-control" readonly>
								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="date"> Date <span class="text-red">*</span></label>
									<input type="date" name="date" id="date" value="{{ old('date') }}" class="form-control datepicker @error('date') is-invalid @enderror" placeholder="Enter date" required>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="increment_amount">Increment Amount<span class="text-red">*</span></label>
									<input type="number" value="{{ old('increment_amount') }}" name="increment_amount" id="increment_amount" class="form-control salary" placeholder="Enter increment amount" required>

                                    @error('increment_amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror
								</div>
							</div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="increment_reason">Increment Reason<span class="text-red">*</span></label>
                                    <textarea name="increment_reason" id="increment_reason" class="form-control" cols="2" rows="2" required>{!! old('increment_reason') !!}</textarea>
								</div>
							</div>

                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2 create">Submit</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script>
    //calculation
    $("#increment_amount").on('input', function(){
        var sum = 0;
        $('.salary').each(function(){
            sum += parseFloat(this.value);
        });
        $('#current_salary').val(sum);
    })
</script>
@endpush
@endsection




