<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Staff Salary Invoice</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

       <?php
    
    $invoiceBgPath = 'back_height.jpg';
    
    if (isset($design->invoice_bg) && !empty($design->invoice_bg)) {
        $potentialBgFile = 'img/' . $design->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        body, h2, p {
            margin: 0;
            padding: 0;
        }

        @page {
            size: A4 portrait;
            margin: 12mm 16mm; /* Reduced margins */
        }

        .company-header img,
        .company-footer img {
            width: 100%;
            height: 100px; /* Reduced height */
            object-fit: contain;
            display: block;
        }

        .invoice {
            width: 100%;
            max-width: 500px; /* Adjusted for A4 width */
            margin: auto;
            padding: 15px; /* Reduced padding */
            border: 1px solid #ddd;
            box-sizing: border-box;
            background: white;
            page-break-inside: avoid;
            overflow: hidden; /* Prevents content overflow */
              background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .invoice-title {
            text-align: center;
            margin-bottom: 8px; /* Adjusted spacing */
            font-size: 18px; /* Adjusted font size */
        }

        .info {
            margin-bottom: 10px; /* Reduced spacing */
        }
        .info .row {
            display: flex;
            justify-content: space-between;
        }

        .col-left,
        .col-right {
            width: 48%; /* Adjusts the width of the left and right columns */
        }

        .info p {
            font-size: 16px; /* Ensure the font size stays consistent */
            margin-bottom: 4px;
            margin-left: 10px;
        }

        .col-right p {
            text-align: right;
            margin-right: 15px;
        }

        /* Invoice Table */
        table {
            width: 100%;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 3px; /* Reduced padding */
            text-align: left;
            border: 1px solid #ddd;
            font-size: 13px; /* Reduced font size */
        }

        table th {
            background-color: #f8f8f8;
            font-size: 14px;
        }

        .signature-section {
            font-size: 13px;
            margin-top: 8px;
        }

        .signature-section .row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 8px; /* Adjusted spacing */
        }

        .signature-section .col-6 {
            width: 48%;
        }

        .signature-section p {
            font-weight: bold;
            margin-top: 10px;
            text-align: left;
            margin-left: 15px;
            font-size: 12px;
        }

        .signature-section .col-6.text-right p {
            text-align: right;
            margin-right: 15px;
        }

        @media print {
            .company-header img{
                margin-top: -10px !important;

            }
            body {
                margin: 0;
                padding: 0;
            }
            .info p {
               font-size: 14px;
            }

            .invoice {
                page-break-after: always;
            }
              .print-table th, .print-table td {
                background: transparent !important;
            }
        }
    </style>

</head>
<body onload="auto_print()">

    <!-- Invoice -->
    <div class="invoice">
        <header class="company-header">
            @if($design && $design->invoice_header)
                <img src="{{ asset('img/' . $design->invoice_header) }}" alt="Header Image">
            @endif
        </header>

        <div class="info">
            <h3 class="invoice-title">Salary Receipt</h3>
            <div class="row">
                <div class="col-left">
                    <p><strong>Staff ID: </strong>{{ $data->staff->id ?? '--' }}</p>
                    <p><strong>Name:</strong> {{ $data->staff->name ?? '--' }}</p>
                    <p><strong>Phone:</strong> {{ $data->staff->phone ?? '--' }}</p>
                </div>
                <div class="col-right">
                    <p><strong>Receipt No:</strong> {{ $data->receipt_no ?? '--' }}</p>
                    <p><strong>Date:</strong> {{ now()->format('d-m-Y') }}</p>
                    <p><strong>Month:</strong> {{ \Carbon\Carbon::parse($data->month)->format('F, Y') ?? '' }}</p>
                </div>
            </div>
        </div>

        <table class="table table-bordered mt-3 print-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Basic Salary</td>
                    <td class="text-right">{{ $data->staff->salary ?? '' }}</td>
                </tr>
                <tr>
                    <td>Previous Paid</td>
                    <td class="text-right">{{ $totalPaid - $data->amount ?? '' }}</td>
                </tr>
                <tr>
                    <td>Currently Paid </td>
                    <td class="text-right">{{ $data->amount ?? '' }}</td>
                </tr>
                <tr>
                    <td>Due Amount</td>
                    <td class="text-right">{{ $data->staff->salary - $totalPaid ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Total Paid</strong></td>
                    <td class="text-right"><strong>{{ $totalPaid ?? '' }}</strong></td>
                </tr>
            </tbody>
        </table>

        <div class="signature-section">
            <div class="row">
                <div class="col-6">
                    <p> ________________________<br>
                        <strong>Teacher's Signature</strong>
                    </p>
                </div>
                <div class="col-6 text-right">
                    <p> __________________________<br>
                        <strong>Account's Signature</strong>
                    </p>
                </div>
            </div>
        </div>

        <footer class="company-footer">
            @if($design && $design->invoice_footer)
                <img src="{{ asset('img/' . $design->invoice_footer) }}" alt="Footer Image">
            @endif
        </footer>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
    <script>
        function auto_print() {
            window.print();
        }
    </script>

</body>
</html>
