@extends('dashboard.master')
@section('title', 'Staff Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Staff Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back Button" href="{{ route('staff.index') }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create Button" href="{{ route('staff.create') }}" type="button" class="btn btn-sm btn-success">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <div class="row">
                        <div class="col-sm-6">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr class="btn-primary">
                                    <td colspan="2">Staff Details</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td width="30%">Date</td>
                                    <td>{{ Carbon\Carbon::parse($data->join_date)->format('d F, Y') ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Staff ID</td>
                                    <td>{{ $data->staff_user_id ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Name</td>
                                    <td>{{ $data->name ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Gender</td>
                                    <td>
                                        @if($data->gender == 1)
                                        Male
                                        @elseif($data->gender == 2)
                                        Female
                                        @endif
                                    </td>
                                </tr>

                                <tr>
                                    <td>Salary</td>
                                    <td>{{ $data->salary ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Phone</td>
                                    <td>{{ $data->phone ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Email</td>
                                    <td>{{ $data->email ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Blood Group</td>
                                    <td>{{ $data->blood_group ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Status</td>
                                    <td>
                                        @if($data->status == 1)
                                            <span class="badge badge-primary" title="Active">Active</span>
                                        @elseif($data->status == 0)
                                            <span class="badge badge-danger" title="InActive">InActive</span>
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        </div>

                        <div class="col-sm-6">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <tbody>
                                @php
                                    $cardNames = json_decode($data->card_name);
                                    $cardNumbers = json_decode($data->card_no);
                                    $cardPhotos = json_decode($data->card_photo);
                                @endphp

                                <tr>
                                    <td>Designation</td>
                                    <td>{{ $data->designation ?? '--' }}</td>
                                </tr>

                                {{-- <tr>
                                    <td>Idenity Card Name</td>
                                    <td>
                                    @foreach($cardNames as $cardName)
                                        <span>
                                            @if($cardName == 1) NID,
                                            @elseif($cardName == 2) Passport,
                                            @elseif($cardName == 3) Birth Certificate,
                                            @elseif($cardName == 4) Driving License
                                            @endif
                                        </span>
                                    @endforeach
                                    </td>
                                </tr>

                                <tr>
                                    <td>Idenity Card No</td>
                                    <td>
                                        @foreach($cardNumbers as $cardNumber)
                                            <span> {{ $cardNumber }} ,  </span>
                                        @endforeach
                                    </td>
                                </tr>

                                <tr>
                                    <td>Idenity Card Photo</td>
                                    <td>
                                    @foreach($cardPhotos as $cardPhoto)
                                        <span> <img height="50px" width="100px" src="{{ asset('backend/img/staff/'.$cardPhoto )}}" alt="ID Card Photo">,
                                        </span>
                                    @endforeach
                                    </td>
                                </tr> --}}

                                <tr>
                                    <td>Address</td>
                                    <td>{{ $data->address ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Description</td>
                                    <td>{{ $data->description ?? '--' }}</td>
                                </tr>

                                <tr>
                                    <td>Photo</td>
                                    <td><img height="50px" width="100px" src="{{ asset('backend/img/staff/'.$data->image)}}" alt="Photo">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Created By</td>
                                    <td>Super Admin</td>
                                </tr>

                            </tbody>
                        </table>
                        </div>
                    </div>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection




