@extends('dashboard.master')
@section('title', 'Student Comment Edit')
@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="page-title-wrapper">
                <div class="page-title-heading">
                    <div class="page-title-icon">
                        <i class="nav-icon fas fa-mosque"></i>
                    </div>
                    <span>
                        <b>Student Comment Edit</b>
                    </span>
                </div>
                <div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i> Back
                    </a>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <form class="forms-sample add-class" enctype="multipart/form-data"
                    action="{{ route('student.comment.update', $data->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <!-- Exam -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Exam <span class="text-red">*</span></label>
                                    <select name="exam_id" id="exam_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($exams as $exam)
                                            <option value="{{ $exam->id }}" @if($exam->id == $data->exam_id) selected @endif>
                                                {{ $exam->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- Session -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Session <span class="text-red">*</span></label>
                                    <select name="session_id" id="session_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($stusessions as $session)
                                            <option value="{{ $session->id }}" @if($session->id == $data->session_id) selected @endif>
                                                {{ $session->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <!-- Class -->
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">Class <span class="text-red">*</span></label>
                                    <select name="class_id" id="class_id" class="form-control">
                                        <option value="">Select One</option>
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}" @if($class->id == $data->class_id) selected @endif>
                                                {{ $class->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <!-- Student Comment Table -->
                        <div class="table-responsive hideClass" style="display: none;">
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Student</th>
                                        <th>Comment</th>
                                    </tr>
                                </thead>
                                <tbody id="student_data">
                                    <!-- Initially loaded data -->
                                    @foreach ($students as $student)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $student->student->name }} | {{ $student->student->roll_no }} | {{ $student->student->register_no }}
                                            <input type="hidden" name="student_id[]" value="{{ $student->student_id }}">
                                        </td>
                                        <td>
                                            <textarea name="comment[]" class="form-control" rows="2">{{ trim($student->comment) }}</textarea>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="row mt-20 hideClass" style="display: none;">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-primary mr-2">Update</button>
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </section>
</div>

@push('js')
<script>
$(document).ready(function () {
    function loadStudents() {
        var session_id = $('#session_id').val();
        var class_id = $('#class_id').val();
        var exam_id = $('#exam_id').val();
        var _token = $('meta[name="csrf-token"]').attr('content');

        // Hide and reset first
        $('#student_data').empty();
        $('.hideClass').hide();

        if (!session_id || !class_id || !exam_id) return;

        $.ajax({
            url: "{{ route('exam.wise.student') }}",
            type: "POST",
            data: {
                class_id: class_id,
                session_id: session_id,
                exam_id: exam_id,
                _token: _token,
            },
            success: function (response) {
                console.log(response); // Debugging
                $('#student_data').empty();

                if (response.length > 0) {
                    response.forEach((student, index) => {
                        let commentText = student.exam_comment?.comment ?? '';

                        var row = `<tr>
                            <td>${index + 1}</td>
                            <td>${student.name} | ${student.roll_no} | ${student.register_no}
                                <input type="hidden" name="student_id[]" value="${student.id}">
                            </td>
                            <td>
                                <textarea name="comment[]" class="form-control" rows="2">${commentText}</textarea>
                            </td>
                        </tr>`;

                        $('#student_data').append(row);
                    });

                    $('.hideClass').show();
                } else {
                    $('.hideClass').hide();
                }
            },
            error: function (xhr, status, error) {
                console.error(error);
                alert("An error occurred while fetching student data.");
            }
        });
    }

    $('#exam_id, #class_id, #session_id').on('change', loadStudents);

    // Optionally call it once on page load if all are selected
    if ($('#exam_id').val() && $('#class_id').val() && $('#session_id').val()) {
        loadStudents();
    }
});
</script>
@endpush

@endsection
