@extends('dashboard.master')
@section('title', 'Create Money Receipt')
@push('css')
<style>
    .bangla{
            font-weight: 0;
            font-size:15px;
        }
</style>
@endpush

@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Create Money Receipt</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('money-receipt.store') }}" method="POST">
						@csrf
						<div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="receipt_no"><span class="bangla">রিসিট নং/</span > Receipt No<span class="text-red">*</span></label>
									<input type="text" name="receipt_no" id="receipt_no " value="{{ $receipt }}" class="form-control" placeholder="receipt no" readonly>

                                    <input type="hidden" name="student_id" value="{{ $data->id }}">

									@error('receipt_no')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="form_no"><span class="bangla">নিবন্ধন নং</span>/Register No <span class="text-red">*</span></label>
									<input type="text" name="register_no" id="register_no" value="{{ $data->register_no }}" class="form-control datepicker @error('form_no') is-invalid @enderror" readonly>

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="name"><span class="bangla">নাম</span>/Student Name<span class="text-red">*</span></label>

									<input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control @error('name') is-invalid @enderror" placeholder="নাম লিখুন" readonly>

									@error('name')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="department"><span class="bangla">ক্লাস</span>/Class<span class="text-red">*</span></label>

                                    <input type="text" id="department_id" value="{{ $data->stuclass->name }}" class="form-control @error('department_id') is-invalid @enderror" readonly>

                                    <input type="hidden" name="department_id" value="{{ $data->stuclass->id }}">

									@error('department_id')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="date">Date<span class="text-red">*</span></label>
									<input type="date" name="date" id="date" value="{{ date('Y-m-d') }}" class="form-control" placeholder="Enter date" required>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="month"><span class="bangla">মাস</span>/Month<span class="text-red">*</span></label>
									<input type="month" name="month" id="month" value="{{ old('month') }}" class="form-control @error('month') is-invalid @enderror" placeholder="মাস লিখুন" required>

									@error('month')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="amount"><span class="bangla">পরিমাণ</span>/Amount <span class="text-red">*</span></label>
									<input type="text" name="amount" id="amount" value="{{ old('amount') }}" class="form-control @error('amount') is-invalid @enderror" placeholder="পরিমাণ লিখুন" required>

									@error('amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-8">
								<div class="form-group">
									<label for="in_word"><span class="bangla">কথায়</span>/In Word </label>

                                    <input type="text" name="in_word" id="in_word" value="{{ old('in_word') }}" class="form-control @error('in_word') is-invalid @enderror" placeholder="কথায় লিখুন" >

                                    {{-- <textarea rows="3" name="in_word" id="in_word" class="form-control" placeholder="কথায় লিখুন" >{!! old('in_word') !!}</textarea> --}}

								</div>
							</div>

							<div class="col-sm-12">
								<div class="form-group">
									<label for="received_purpose"><span class="bangla">বাবদ</span>/On Account Of<span class="text-red">*</span></label>
									<textarea rows="2" name="received_purpose" id="received_purpose" class="form-control" placeholder="বাবদ লিখুন" required>{!! old('received_purpose') !!}</textarea>

									@error('received_purpose')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							{{-- <div class="col-sm-6">
								<div class="form-group">
									<label for="address"><span class="bangla">ঠিকানা</span>/Address<span class="text-red">*</span></label>
									<textarea rows="3" name="address" id="address" class="form-control" placeholder="ঠিকানা লিখুন" required>{!! old('address') !!}</textarea>

									@error('address')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div> --}}

						</div>

						<div class="row mt-30">
							<div class="col-sm-12">
								<button type="submit" class="btn btn-success mr-2">Create</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection
