@extends('dashboard.master')
@section('title', 'Leave Details')
<?php

$invoiceBgPath = 'back_height.jpg';

if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
    $potentialBgFile = 'img/' . $invoice->invoice_bg;
    if (file_exists(public_path($potentialBgFile))) {
        $invoiceBgPath = $potentialBgFile;
    }
}
?>

<style>
    .printArea {
        background-image: url('{{ asset($invoiceBgPath) }}') !important;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        height: fit-content;
    }

    @media print {
        body {
            background-image: url('{{ asset($invoiceBgPath) }}') !important;
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
            background-size: cover;
        }

        #data_table th,
        #data_table td {
            background: transparent !important;
        }
    }
</style>
@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Leave Details</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="Create" href="{{ route('student.leave.create') }}" type="button"
                            class="btn btn-sm btn-primary">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                        <a title="a4 print" id="printButton" type="button" class="btn btn-sm btn-danger">
                            <i class="fas fa-file mr-1"></i>
                            Print
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-body printArea">
                        <img id="header-img" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header"
                            style="width:100%; height:150px; margin-bottom:20px;">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th width="30%">From Date</th>
                                    <td width="70%">{{ \Carbon\Carbon::parse($data->from_date)->format('d-M-Y') ?? '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <th width="30%">To Date</th>
                                    <td width="70%">{{ \Carbon\Carbon::parse($data->to_date)->format('d-M-Y') ?? '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <th width="30%">Total Day</th>
                                    <td width="70%">{{ $data->days ?? '' }} days</td>
                                </tr>
                                <tr>
                                    <th width="30%">Student Name</th>
                                    <td width="70%">{{ $data->students->name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th width="30%">Student Roll</th>
                                    <td width="70%">{{ $data->students->roll_no ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th width="30%">Student Reg</th>
                                    <td width="70%">{{ $data->students->register_no ?? '' }}</td>
                                </tr>
                                <tr>
                                    <th width="30%">Class Name</th>
                                    <td width="70%">{{ $data->stuclass->name ?? '' }}</td>
                                </tr>

                                <tr>
                                    <th width="30%">Taken By </th>
                                    <td width="70%">

                                        @if ($data->leave_type == 1)
                                            Self
                                        @else
                                            Gurdian
                                        @endif
                                    </td>
                                </tr>

                                @if ($data->leave_type == 2)
                                    <tr>
                                        <th width="30%">Gurdian Name </th>
                                        <td width="70%">{{ $data->gurdian_name ?? '' }}</td>
                                    </tr>
                                    <tr>
                                        <th width="30%">Gurdian Phone</th>
                                        <td width="70%">{{ $data->gurdian_phone ?? '' }}</td>
                                    </tr>
                                @endif

                                <tr>
                                    <th width="30%">Approved By</th>
                                    <td width="70%">{{ $data->users->name ?? '' }}</td>
                                </tr>

                                <tr>
                                    <th width="30%">Note</th>
                                    <td width="70%">{{ $data->note ?? '-' }}</td>
                                </tr>
                            </thead>
                        </table>
                        <div id="footer-img">
                            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer"
                                style="width:100%; height:150px; margin-top:20px;">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script>
            $('#printButton').on('click', function() {
                var printContents = $('.printArea').html();
                var originalContents = $('body').html();

                $('body').html(printContents);
                window.print();

                $('body').html(originalContents);
                location.reload();
            });
        </script>
    @endpush
@endsection
