@extends('dashboard.master')
@section('title', 'Neshab Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Neshab Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('student.neshab.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">

			<div class="card" style="width: 40%">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover" >
                        <thead>
                            <tr>
                                <th width="30%">Exam Name </th>
                                <td width="70%">{{ $data->exam->name ?? ''}}</td>
                            </tr>
                            <tr>
                                <th width="30%">Class Name</th>
                                <td width="70%">{{ $data->stuclass->name ?? ''}}</td>
                            </tr>
                            <tr>
                                <th width="30%">Session</th>
                                <td width="70%">{{ $data->stusession->name ?? ''}}</td>
                            </tr>
                        </thead>
                    </table>
				</div>
			</div>

			<div class="card">
				<div class="card-body">
					<table id="data_table" class="table table-bordered table-striped data-table table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Subject</th>
                                <th>Lession</th>
                                <th>Note</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($subjects as $subject)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $subject->subject->name }}</td>
                                <td>Page no : <b>{{ $subject->start_page }}</b>  - <b>{{ $subject->end_page }}</b> </td>
                                <td>{{ $subject->note}}</td>
                            </tr>

                            @endforeach

                        </tbody>
                    </table>
				</div>
			</div>

		</div>
	</section>
</div>

@endsection
