@extends('dashboard.master')
@section('title', 'ছাত্রদের আইডিকার্ড')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <style>
        td .student-cell {
            display: flex;
            flex-direction: column;
            justify-content: center;
            height: 100%;
            text-align: center;
        }

        td {
            vertical-align: middle !important;
        }

        .student-container {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 20px;
            padding: 20px;
        }

        .student_card {
            width: 74mm;
            height: 105mm;
            box-sizing: border-box;
            padding: 10px;
            border: 2px solid goldenrod;
            border-radius: 8px;
            background-image: url('{{ asset('back_height.jpg') }}');
            background-size: cover;
            background-position: center;
            position: relative;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            color: #000;
            page-break-inside: avoid;
        }

        .logo {
            width: 50px;
            height: 50px;
            margin: 10px auto 5px;
            display: block;
            border-radius: 50%;
            background-size: cover;
            background-position: center;
        }

        .header {
            text-align: center;
            font-size: 11px;
            color: darkgreen;
            font-weight: bold;
            margin-bottom: 3px;
            line-height: 1.4;
        }

        .sub-header {
            text-align: center;
            font-size: 10px;
            color: #333;
            margin-bottom: 8px;
        }

        .photo {
            width: 70px;
            height: 80px;
            border-radius: 4px;
            border: 2px solid #000;
            margin: 0 auto;
            background-size: cover;
            background-position: center;
        }

        .name {
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            margin-top: 6px;
            margin-bottom: 14px;
        }

        .info {
            font-size: 13px;
            line-height: 1.6;
            padding-left: 10px;
        }

        .notice {
            font-size: 13px;
            text-align: center;
            font-weight: bold;
            padding: 6px;
            margin: 12px auto;
            border: 2px solid goldenrod;
            border-radius: 6px;
            background-color: #fff8dc;
            width: 90%;
        }

        .title {
            text-align: center;
            font-size: 13px;
            font-weight: bold;
            line-height: 1.6;
            margin-top: 10px;
        }

        .event {
            text-align: center;
            font-size: 12px;
            margin-top: 20px;
            line-height: 1.5;
            margin-bottom: 20px;
        }

        .condition {
            text-align: center;
            font-size: 12px;
            color: red;
            font-weight: bold;
            background-color: #fff;
            border: 1px solid #000;
            padding: 6px;
            width: 90%;
            margin: 0 auto;
            border-radius: 4px;
            line-height: 1.5;
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Students ID Cards </b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Create" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>
                        <a title="print-all" href="{{ route('student.idcard.print.all') }}" type="button"
                            class="btn btn-sm btn-primary print-all">Print all</a>

                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                {{-- Filter Section --}}
                <div class="card filter-section">
                    <div class="card-body">
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="class_id">শ্রেণী:</label>
                                    <select name="class_id" id="class_id" class="form-control select2">
                                        <option value="">সকল শ্রেণী</option>
                                        {{-- এখানে আপনার শ্রেণীর অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="session_id">শিক্ষাবর্ষ:</label>
                                    <select name="session_id" id="session_id" class="form-control select2">
                                        <option value="">সকল শিক্ষাবর্ষ</option>
                                        {{-- এখানে আপনার শিক্ষাবর্ষের অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12 text-right mt-2">
                                <button type="button" id="filterButton" class="btn btn-info">
                                    <i class="fas fa-filter mr-1"></i> ফিল্টার করুন
                                </button>
                                <button type="button" id="clearFilterButton" class="btn btn-warning ml-2">
                                    <i class="fas fa-times mr-1"></i> ফিল্টার মুছে ফেলুন
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- End Filter Section --}}
                <div class="card">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Student</th>
                                    <th>Front Side</th>
                                    <th>Back Side</th>
                                    <th>Print</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            $(document).ready(function() {
                var dTable = $('#data_table').DataTable({
                    order: [],
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    processing: true,
                    responsive: false,
                    scrollX: true,
                    autoWidth: false,
                    serverSide: true,
                    scroller: {
                        loadingIndicator: false
                    },
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "{{ route('students.ids') }}",
                        data: function(d) {


                            d.class_id = $('#class_id').val();
                            d.session_id = $('#session_id').val();
                        },
                        type: "get"
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            searchable: false
                        },
                        {
                            data: 'student',
                            name: 'student'
                        },
                        {
                            data: 'front_end',
                            name: 'front_end'
                        },
                        {
                            data: 'back_end',
                            name: 'back_end'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],
                });
                $('#filterButton').on('click', function() {
                    dTable.ajax.reload();
                });

                $('#clearFilterButton').on('click', function() {

                    $('#class_id').val('').trigger('change');
                    $('#session_id').val('').trigger('change');
                    dTable.ajax.reload(); // ফিল্টার মুছে ফেলার পর ডাটাটেবিল রিলোড করুন
                });
            });

            $(document).on('click', '.print-all', function(e) {
                e.preventDefault();

                var studentIds = [];
                $('.student_card input[name="student_id[]"]').each(function() {
                    studentIds.push($(this).val());
                });

                if (studentIds.length === 0) {
                    alert('Please select at least one student to print.');
                    return;
                }

                // Create and submit form
                var form = $('<form>', {
                    action: $(this).attr('href'),
                    method: 'POST',
                    target: '_blank'
                });

                form.append($('<input>', {
                    type: 'hidden',
                    name: '_token',
                    value: '{{ csrf_token() }}'
                }));

                studentIds.forEach(function(id) {
                    form.append($('<input>', {
                        type: 'hidden',
                        name: 'student_ids[]',
                        value: id
                    }));
                });

                $('body').append(form);
                form.submit();
                form.remove();
            });
        </script>
    @endpush
@endsection
