<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Student ID Card (3.2in × 2.1in Portrait)</title>

  <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
  ?>

  <style>
    :root {
      --card-w: 2.1in;   /* width */
      --card-h: 3.2in;   /* height */
      --border-color: goldenrod;
    }

    @page {
      size: var(--card-w) var(--card-h);
      margin: 0;
    }

    html, body {
      margin: 0;
      padding: 0;
      font-family: 'Noto Sans Bengali', sans-serif;
      background: #eaeaea;
    }

    body {
      display: grid;
      place-items: center;
      min-height: 100vh;
    }

    .card {
      width: var(--card-w);
      height: var(--card-h);
      border: 2px solid var(--border-color);
      border-radius: 6px;
      background-image: url('{{ asset($invoiceBgPath) }}');
      background-size: cover;
      background-position: center;
      box-sizing: border-box;
      padding: 6px;
      box-shadow: 0 0 5px rgba(0,0,0,.1);
      overflow: hidden;
    }

    .header-strip {
      width: 100%;
      display: block;
      margin-bottom: 4px;
    }

    .photo {
      width: 60px;
      height: 70px;
      border: 2px solid #000;
      border-radius: 4px;
      margin: 0 auto 4px;
      background-image: url('{{ asset('backend/img/student/' . $data->image) }}');
      background-size: cover;
      background-position: center;
    }

    .name {
      text-align: center;
      font-size: 13px;
      font-weight: bold;
      margin: 4px 0;
    }

    .info {
      font-size: 11px;
      line-height: 1.4;
    }

    .notice {
      font-size: 10px;
      text-align: center;
      font-weight: bold;
      padding: 4px;
      margin: 6px auto;
      border: 2px solid var(--border-color);
      border-radius: 4px;
      background-color: #fff8dc;
      width: 95%;
    }

    .title {
      text-align: center;
      font-size: 11px;
      font-weight: bold;
      margin-top: 4px;
    }

    .event {
      text-align: center;
      font-size: 10px;
      margin: 6px 0;
      line-height: 1.3;
    }

    .condition {
      text-align: center;
      font-size: 9px;
      color: red;
      font-weight: bold;
      border: 1px solid #000;
      background: #fff;
      padding: 4px;
      border-radius: 4px;
      line-height: 1.3;
      margin-top: 6px;
    }

    /* Back page start on new page */
    .card + .card {
      page-break-before: always;
    }

    @media print {
      body { background: none; min-height: initial; }
      .card { box-shadow: none; }
    }
  </style>
</head>
<body>

  <!-- FRONT -->
  <div class="card">
    @if ($invoice && $invoice->invoice_header)
      <img class="header-strip" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header">
    @endif

    <div class="photo"></div>
    <div class="name">{{ $data->name ?? '' }}</div>

    <div class="info">
      পিতার নাম: {{ $data->father_name ?? '' }}<br>
      ক্লাস: {{ $data->stuclass->name ?? '' }}<br>
      রোল নং: {{ $data->roll_no ?? '' }}<br>
      লিঙ্গ:
      @if ($data->gender == 1) ছেলে
      @elseif($data->gender == 2) মেয়ে
      @endif <br>
      মোবাইল: {{ $data->gurdian_mobile ?? '' }}<br>
      রেজিস্টার নাম্বার: {{ $data->register_no ?? '' }}
    </div>
  </div>

  <!-- BACK -->
  <div class="card">
    @if ($invoice && $invoice->invoice_header)
      <img class="header-strip" src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header">
    @endif

    <div class="notice">
      ব্যবহারকারী ব্যতীত এই কার্ডটি অন্য কোথাও পাওয়া গেলে<br>
      মাদ্রাসার ঠিকানায় ফেরত দেওয়ার অনুরোধ রইল।
    </div>

    <div class="title">{{ $setting->long_name ?? '' }}</div>

    <div class="event">
      {{ $setting->address ?? '' }}<br>
      ইস্যু তারিখ: {{ \Carbon\Carbon::parse($data->date ?? now())->format('d/m/Y') }} ইং<br>
      মেয়াদকাল: {{ \Carbon\Carbon::parse($data->date ?? now())->addYears(1)->format('d/m/Y') }} ইং
    </div>

    <div class="condition">
      রাষ্ট্রদ্রোহী কাজে জড়িত না থাকার শর্তে<br>
      শুধুমাত্র অধ্যয়নকালীন সময়ের জন্য প্রযোজ্য
    </div>
  </div>

  <script>
    setTimeout(() => window.print(), 500);
  </script>
</body>
</html>
