<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Student ID Cards</title>
  <style>
    @page {
      size: landscape;
      margin: 10mm;
    }

    body {
      font-family: 'Noto Sans Bengali', sans-serif;
      margin: 0;
      padding: 0;
      background: #eaeaea;
    }

    .student-block {
      display: flex;
      justify-content: center;
      flex-wrap: wrap;
      gap: 20px;
      page-break-inside: avoid;
    }

    .card {
      width: 105mm;
      height: 74mm;
      box-sizing: border-box;
      padding: 10px;
      border: 2px solid goldenrod;
      border-radius: 8px;
      background-image: url('{{ asset('back_height.jpg') }}');
      background-size: cover;
      background-position: center;
      position: relative;
      box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
      color: #000;
    }

    .logo {
      width: 50px;
      height: 50px;
      margin: 10px auto 5px;
      display: block;
      border-radius: 50%;
      background-size: cover;
      background-position: center;
    }

    .header {
      text-align: center;
      font-size: 11px;
      color: darkgreen;
      font-weight: bold;
      margin-bottom: 3px;
      line-height: 1.4;
    }

    .sub-header {
      text-align: center;
      font-size: 10px;
      font-weight: normal;
      color: #333;
      margin-bottom: 8px;
    }

    .photo {
      width: 70px;
      height: 80px;
      border-radius: 4px;
      border: 2px solid #000;
      margin: 0 auto;
      background-size: cover;
      background-position: center;
    }

    .name {
      text-align: center;
      font-size: 14px;
      font-weight: bold;
      margin-top: 6px;
      margin-bottom: 14px;
    }

    .info {
      font-size: 14px;
      line-height: 1.6;
      padding-left: 10px;
    }

    .notice {
      font-size: 13px;
      text-align: center;
      font-weight: bold;
      padding: 6px;
      margin: 12px auto;
      border: 2px solid goldenrod;
      border-radius: 6px;
      background-color: #fff8dc;
      width: 90%;
    }

    .title {
      text-align: center;
      font-size: 13px;
      font-weight: bold;
      line-height: 1.6;
      margin-top: 10px;
    }

    .event {
      text-align: center;
      font-size: 12px;
      margin-top: 20px;
      line-height: 1.5;
      margin-bottom: 20px;
    }

    .condition {
      text-align: center;
      font-size: 12px;
      color: red;
      font-weight: bold;
      background-color: #fff;
      border: 1px solid #000;
      padding: 6px;
      width: 90%;
      margin: 0 auto;
      border-radius: 4px;
      line-height: 1.5;
    }

    hr {
      border: 1px dashed #aaa;
      margin: 40px auto;
      width: 90%;
    }

    @media print {
      body {
        background: none;
      }

      hr {
        display: block;
        page-break-after: always;
      }
    }
  </style>
</head>
<body>

@foreach($students as $data)
  <div class="student-block">

    <!-- Front Side -->
    <div class="card">
      <div class="logo" style="background-image: url('{{ asset('img/'.$setting->logo) }}');"></div>
      <div class="header">{{ $setting->long_name ?? '' }}</div>
      <div class="sub-header">{{ $setting->address ?? '' }}</div>
      <div class="photo" style="background-image: url('{{ asset('backend/img/student/'.$data->image) }}');"></div>
      <div class="name">{{ $data->name ?? '' }}</div>
      <div class="info">
        ক্লাস: {{ $data->stuclass->name ?? '' }} {{ $data->stusession->name ?? '' }}<br>
        রোল নং: {{ $data->roll_no ?? '' }}<br>
        লিঙ্গ:
        @if($data->gender == 1) ছেলে
        @elseif($data->gender == 2) মেয়ে
        @endif<br>
        মোবাইল: {{ $data->gurdian_mobile ?? '' }}<br>
        রেজিস্টার নাম্বার : {{ $data->register_no ?? '' }}
      </div>
    </div>

    <!-- Back Side -->
    <div class="card">
      <div class="logo" style="background-image: url('{{ asset('img/'.$setting->logo) }}');"></div>
      <div class="notice">
        ব্যবহারকারী ব্যতীত এই কার্ডটি অন্য কোথাও পাওয়া গেলে<br>
        মাদ্রাসার ঠিকানায় ফেরত দেওয়ার অনুরোধ রইল।
      </div>
      <div class="title">{{ $setting->long_name ?? '' }}</div>
      <div class="event">
        {{ $setting->address ?? '' }}<br>
        ইস্যু তারিখ: {{ \Carbon\Carbon::parse($data->date)->format('d/m/Y') ?? '' }} ইং<br>
        মেয়াদকাল: {{ \Carbon\Carbon::parse($data->date)->addYears(1)->format('d/m/Y') ?? '' }} ইং
      </div>
      <div class="condition">
        রাষ্ট্রদ্রোহী কাজে জড়িত না থাকার শর্তে<br>
        শুধুমাত্র অধ্যয়নকালীন সময়ের জন্য প্রযোজ্য
      </div>
    </div>

  </div>

  <hr>
@endforeach

</body>
</html>
