@extends('dashboard.master')
@section('title', 'ছাত্রের তালিকা')
@push('css')
    <link rel="stylesheet" href="{{ asset('backend/DataTables/datatables.min.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css"
        integrity="sha512-O03ntXoVqaGUTAeAmvQ2YSzkCvclZEcPQu1eqloPaHfJ5RuNGiS4l+3duaidD801P50J28EHyonCV06CUlTSag=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />

    <style>
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }

        /* .table.data-table {
                    width: 100% !important;
                    display: block;
                } */


        #data_table {
            width: 100% !important;
            table-layout: auto !important;
        }

        #data_table th,
        #data_table td {
            white-space: nowrap;
            /* এটা দিলে কলামের মধ্যে data কাটবে না, বরং scroll আসবে */
        }
    </style>
@endpush

@section('content')

    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="page-title-wrapper">
                    <div class="page-title-heading">
                        <div class="page-title-icon">
                            <i class="nav-icon fas fa-mosque"></i>
                        </div>
                        <span>
                            <b>Student List</b>
                        </span>
                    </div>

                    <div class="page-title-actions">
                        <a title="Create" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                            <i class="fas fa-arrow-left mr-1"></i>
                            Back
                        </a>

                        <a title="Create" href="{{ route('student.create') }}" type="button"
                            class="btn btn-sm btn-success">
                            <i class="fas fa-plus mr-1"></i>
                            Create
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <section class="content">
            <div class="container-fluid">
                {{-- Filter Section --}}
                <div class="card filter-section">
                    <div class="card-body">
                        <div class="row">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="class_id">শ্রেণী:</label>
                                    <select name="class_id" id="class_id" class="form-control select2">
                                        <option value="">সকল শ্রেণী</option>
                                        {{-- এখানে আপনার শ্রেণীর অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($classes as $class)
                                            <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="session_id">শিক্ষাবর্ষ:</label>
                                    <select name="session_id" id="session_id" class="form-control select2">
                                        <option value="">সকল শিক্ষাবর্ষ</option>
                                        {{-- এখানে আপনার শিক্ষাবর্ষের অপশনগুলো PHP লুপের মাধ্যমে আসবে --}}
                                        @foreach ($sessions as $session)
                                            <option value="{{ $session->id }}">{{ $session->name }}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="student_type">শিক্ষার্থী ধরন:</label>
                                    <select name="student_type" id="student_type" class="form-control select2">
                                        <option value="">সকল শিক্ষার্থী</option>
                                        <option value="1">অনাবাসিক</option>
                                        <option value="2">আবাসিক </option>
                                        <option value="3">ডে- কেয়ার</option>


                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="admission_type">ভর্তির ধরন:</label>
                                    <select name="admission_type" id="admission_type" class="form-control select2">
                                        <option value="">সকল শিক্ষার্থী</option>
                                        <option value="1">নতুন ভর্তি</option>
                                        <option value="2">পুরাতন ভর্তি</option>


                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="etim_type">এতিম ধরন:</label>
                                    <select name="etim_type" id="etim_type" class="form-control select2">
                                        <option value="">সকল শিক্ষার্থী</option>
                                        <option value="1">এতিম শিক্ষার্থী </option>
                                        <option value="2">অন্যান্য শিক্ষার্থী </option>


                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="gender">ছেলে/মেয়ে:</label>
                                    <select name="gender" id="gender" class="form-control select2">
                                        <option value="">সকল শিক্ষার্থী</option>
                                        <option value="1">ছেলে</option>
                                        <option value="2">মেয়ে</option>

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12 text-right mt-2">
                                <button type="button" id="filterButton" class="btn btn-info">
                                    <i class="fas fa-filter mr-1"></i> ফিল্টার করুন
                                </button>
                                <button type="button" id="clearFilterButton" class="btn btn-warning ml-2">
                                    <i class="fas fa-times mr-1"></i> ফিল্টার মুছে ফেলুন
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                {{-- End Filter Section --}}
                <div class="card">
                    <div class="card-body">
                        <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Image</th>
                                    <th>Reg No</th>
                                    <th>Roll No</th>
                                    <th>Name</th>
                                    <th>Mobile</th>
                                    <th>Class</th>
                                    <th>Student Type</th>
                                    <th>Admission Type</th>
                                    <th>Admission Fee</th>
                                    <th>Monthly Discount</th>
                                    <th>Father</th>
                                    <th>Address</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>
    </div>
    @push('js')
        <script src="{{ asset('backend/DataTables/datatables.min.js') }}"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"
            integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
        <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
        <script>
            $(document).ready(function() {
                var dTable = $('#data_table').DataTable({
                    order: [],
                    scrollX: true,
                    autoWidth: false,
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        [10, 25, 50, 100, "All"]
                    ],
                    columnDefs: [{
                            width: '20px',
                            targets: 0
                        }, // SN
                        {
                            width: '150px',
                            targets: 1
                        }, // Reg No
                        {
                            width: '100px',
                            targets: 2
                        }, // Roll No
                        {
                            width: '200px',
                            targets: 3
                        }, // Name
                        {
                            width: '150px',
                            targets: 4
                        }, // Mobile  
                        {
                            width: '150px',
                            targets: 5
                        }, // Class
                        {
                            width: '150px',
                            targets: 6
                        }, // Student Type
                        {
                            width: '200px',
                            targets: 7
                        }, // Admission Type
                        {
                            width: '250px',
                            targets: 8
                        }, // Admission Fee
                        {
                            width: '200px',
                            targets: 9
                        }, // Monthly Discount
                        {
                            width: '200px',
                            targets: 10
                        }, // admission fee

                        {
                            width: '200px',
                            targets: 11
                        }, // Father
                        {
                            width: '200px',
                            targets: 12
                        }, // Address

                    ],
                    processing: true,
                    responsive: false,
                    serverSide: true,
                    scroller: {
                        loadingIndicator: true
                    },
                    language: {
                        processing: '<i class="ace-icon fa fa-spinner fa-spin orange bigger-500" style="font-size:60px;text-align:center;"></i>'
                    },
                    pagingType: "full_numbers",
                    ajax: {
                        url: "{{ route('student.index') }}",
                        data: function(d) {
                            d.class_id = $('#class_id').val();
                            d.session_id = $('#session_id').val();
                            d.student_type = $('#student_type').val();
                            d.admission_type = $('#admission_type').val();
                            d.gender = $('#gender').val();
                            d.etim_type = $('#etim_type').val();
                        },
                        type: "get"
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            searchable: false
                        },
                        {
                            data: 'image',
                            name: 'image'
                        },
                        {
                            data: 'register_no',
                            name: 'register_no'
                        },
                        {
                            data: 'roll_no',
                            name: 'roll_no'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'gurdian_mobile',
                            name: 'gurdian_mobile'
                        },
                        {
                            data: 'class',
                            name: 'class'
                        },
                        {
                            data: 'student_type',
                            name: 'student_type'
                        },
                        {
                            data: 'admission_type',
                            name: 'admission_type'
                        },
                        {
                            data: 'admission_fee',
                            name: 'admission_fee'
                        },
                        {
                            data: 'monthly_dis',
                            name: 'monthly_dis'
                        },
                        {
                            data: 'father_name',
                            name: 'father_name'
                        },
                        {
                            data: 'address',
                            name: 'address'
                        },
                        {
                            data: 'action',
                            searchable: false,
                            orderable: false
                        }
                    ],
                    dom: "<'row'<'col-sm-2'l><'col-sm-7 text-center'B><'col-sm-3'f>>tipr",
                    buttons: [{
                            extend: 'copy',
                            className: 'btn-sm btn-info',
                            title: 'Student List',
                            header: true,
                            footer: true,
                        },
                        {
                            extend: 'excel',
                            className: 'btn-sm btn-success',
                            title: 'Student List',
                            header: true,
                            footer: true,
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
                                stripHtml: true
                            },

                        },
                        {
                            extend: 'print',
                            className: 'btn-sm btn-danger',
                            title: 'Student List',
                            pageSize: 'A2',
                            header: true,
                            footer: true,
                            orientation: 'landscape',
                            exportOptions: {
                                columns: ':visible',
                                stripHtml: false // ✅ HTML Preserve করার জন্য
                            }
                        },
                        {
                            extend: 'colvis',
                            className: 'btn-sm btn-warning',
                            text: 'Column Visibility',
                            title: 'Column Visibility',
                            columns: ':not(:first-child)'
                        }
                    ],
                });
                $('#filterButton').on('click', function() {
                    dTable.ajax.reload();
                });

                $('#clearFilterButton').on('click', function() {

                    $('#class_id').val('').trigger('change');
                    $('#session_id').val('').trigger('change');
                    dTable.ajax.reload(); // ফিল্টার মুছে ফেলার পর ডাটাটেবিল রিলোড করুন
                });
            });

            $('#data_table').on('click', '.btn-delete[data-remote]', function(e) {
                e.preventDefault();

                const url = $(this).data('remote');
                swal({
                    title: `Are you sure?`,
                    text: "This will permanently delete the student and all related datas. This action can not be undone",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                submit: true,
                                _method: 'delete',
                                _token: "{{ csrf_token() }}"
                            }
                        }).always(function(data) {
                            $('#data_table').DataTable().ajax.reload();
                            if (data.success === true) {
                                toastr.success(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            } else {
                                toastr.error(data.message, {
                                    positionClass: 'toast-bottom-full-width',
                                });
                            }
                        });
                    }
                });
            });

            $('#data_table').on('click', '.status[href]', function(e) {
                e.preventDefault();

                const url = $(this).attr('href');

                swal({
                    title: "Are you sure?",
                    text: "Want to deactivate this student",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: url,
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                _method: 'POST',
                                _token: "{{ csrf_token() }}",
                                status: 2,
                            },
                            success: function(data) {
                                $('#data_table').DataTable().ajax.reload();
                                if (data.success === true) {
                                    toastr.success(data.message, {
                                        positionClass: 'toast-bottom-full-width'
                                    });
                                } else {
                                    toastr.error(data.message, {
                                        positionClass: 'toast-bottom-full-width'
                                    });
                                }
                            },
                            error: function(xhr, status, error) {
                                toastr.error('An error occurred. Please try again.', {
                                    positionClass: 'toast-bottom-full-width'
                                });
                            }
                        });
                    }
                });
            });

            //  toastr.options.timeOut = 300;
            @if (Session::has('success'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true,
                    "timeOut": 2000
                };

                toastr.success("{{ session('success') }}");
            @endif

            @if (Session::has('error'))
                toastr.options = {
                    "closeButton": true,
                    "progressBar": true
                };
                toastr.error("{{ session('error') }}");
            @endif
        </script>
    @endpush
@endsection
