<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8">
    <title>ভর্তি ফর্ম</title>
    <?php
  
    $invoiceBgPath = 'back_height.jpg';
    
    if (isset($invoice->invoice_bg) && !empty($invoice->invoice_bg)) {
        $potentialBgFile = 'img/' . $invoice->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>

    <style>
        @page {
            size: A4;
            margin: 10mm;
        }

        html,
        body {
            width: 210mm;
            height: 297mm;
            margin: 0;
            padding: 0;
            font-family: 'Noto Sans Bengali', sans-serif;
            font-size: 12px;
            background-image: url('{{ asset($invoiceBgPath) }}');

            background-size: 210mm 297mm;
            background-position: center;
            background-repeat: no-repeat;
            color: #000;
        }

        .container {
            width: 100%;
            max-width: 720px;
            margin: 0 auto;
            padding: 10px;
            box-sizing: border-box;
        }

        .section {
            margin-bottom: 12px;
        }

        .section-title {
            font-weight: bold;
            font-size: 15px;
            margin-bottom: 6px;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
        }

        .row p {
            flex: 1 1 48%;
            margin: 0 0 4px;
        }

        .block {
            border: 1px solid #333;
            padding: 8px;
            margin-top: 10px;
        }

        img {
            width: 100%;
            height: auto;
            display: block;
        }

        .header-img {
            max-height: 110px;
            margin-bottom: 10px;
        }

        .footer-img {
            max-height: 90px;
            margin-top: 15px;
        }

        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
                background-size: cover;
            }
        }
    </style>
</head>

<body>
    <div class="container">

        <div class="section" style="position: relative;">
            <img src="{{ asset('img/' . $invoice->invoice_header) }}" alt="Header" class="header-img">

            @if ($data->image)
                <img src="{{ asset('backend/img/student/' . $data->image) }}" alt="Profile"
                    style="position: absolute; top: 0; right: 10px; width: 130px; height: 140px; object-fit: cover; border: 1px solid #000;">
            @endif
        </div>


        <div class="row section">
            <p><strong>ফর্ম নং: </strong> {{ $data->form_no ?? '--' }}</p>
            <p><strong>শিক্ষাবর্ষ:</strong> {{ $year }}</p>
            <p><strong>তারিখ:</strong> {{ $date }}</p>
            <p><strong>শিক্ষার্থীর ধরন:</strong>
                @if ($data->student_type == 1)
                    অনাবাসিক
                @elseif ($data->student_type == 2)
                    আবাসিক
                @elseif($data->student_type == 3)
                    ডে- কেয়ার
                @endif
            </p>
        </div>

        <div class="block">
            <p><strong>আস্সালামু আ'লাইকুম ওয়ারহমাতুল্লাহ!</strong></p>
            <p>
                মাননীয় মুহ্তামিম সাহেব,<br>
                বিনীত নিবেদন এই যে আমি <strong>{{ $data->name ?? '--' }}</strong> যাবতীয় বিধি-বিধান ও নিয়মাবলি এবং
                ভবিষ্যতে গৃহীত আইন-কানুন মেনে চলার অঙ্গীকারবদ্ধ হয়ে অত্র মাদ্রাসায় ভর্তি হওয়ার আবেদন করছি। মেহেরবানী
                করে আমাকে সুযোগ দেওয়ার অনুরোধ জানাচ্ছি।
            </p>
        </div>

        <div class="row section" style="margin-top: 10px;">
            <p style="margin: 0"><strong>নাম:</strong> {{ $data->name ?? '--' }}</p>
            <p style="margin: 0"><strong>পিতা:</strong> {{ $data->father_name ?? '--' }}</p>
            <p style="margin: 0"><strong>মাতা:</strong> {{ $data->mother_name ?? '--' }}</p>
            <p style="margin: 0"><strong>জন্ম তারিখ:</strong> {{ $birthDay ?? '--' }}</p>
            <p style="margin: 0"><strong>ক্লাস:</strong> {{ $data->stuclass->name ?? '--' }}</p>
            <p style="margin: 0"><strong>গ্রাম:</strong> {{ $data->village ?? '--' }}</p>
            <p style="margin: 0"><strong>ডাকঘর:</strong> {{ $data->post_office ?? '--' }}</p>
            <p style="margin: 0"><strong>থানা:</strong> {{ $data->police_station ?? '--' }}</p>
            <p style="margin: 0"><strong>জেলা:</strong> {{ $data->district ?? '--' }}</p>
            <p style="margin: 0"><strong>ভর্তির ধরন:</strong>
                @if ($data->admission_type == 1)
                    নতুন ভর্তি
                @elseif($data->admission_type == 2)
                    পুরাতন ভর্তি
                @endif
            </p>
            <p style="margin: 0"><strong>জন্ম নিবন্ধন নং:</strong> {{ $data->birthcertificate ?? '--' }}</p>
            <p style="margin: 0"><strong>লিঙ্গ:</strong>
                @if ($data->gender == 1)
                    ছেলে
                @elseif($data->gender == 2)
                    মেয়ে
                @endif
            </p>
            <p style="margin: 0"><strong>এতিম:</strong>
                @if ($data->etim == 1)
                    হ্যাঁ
                @elseif($data->etim == 2)
                    না
                @endif
            </p>
            <p style="margin: 0"><strong>নতুন শিক্ষার্থীর রেজাল্ট:</strong> {{ $data->new_result ?? '--' }}</p>
            <p style="margin: 0"><strong>পূর্ববর্তী মাদ্রাসা:</strong> {{ $data->pre_madrasha ?? '--' }}</p>
            <p style="margin: 0"><strong>পূর্ববর্তী ক্লাস:</strong> {{ $data->pre_class ?? '--' }}</p>
            <p style="margin: 0"><strong>অভিভাবক:</strong> {{ $data->gurdian_name ?? '--' }}</p>
             <p style="margin: 0"><strong>মোবাইল:</strong> {{ $data->gurdian_mobile ?? '--' }}</p>
            @if ($data->gurdian_name_two)
                <p style="margin: 0"><strong>অভিভাবক ২:</strong> {{ $data->gurdian_name_two ?? '--' }}</p>
                
            @endif
            @if ($data->gurdian_name_three)
                <p style="margin: 0"><strong>অভিভাবক ৩:</strong> {{ $data->gurdian_name_three ?? '--' }}</p>
            @endif

            @if ($data->gurdian_mobile_two)
                <p style="margin: 0"><strong>অভিভাবক ২ মোবাইল:</strong> {{ $data->gurdian_mobile_two ?? '--' }}</p>
                
            @endif
            @if ($data->gurdian_mobile_three)
                <p style="margin: 0"><strong>অভিভাবক ৩ মোবাইল:</strong> {{ $data->gurdian_mobile_three ?? '--' }}</p>
            @endif
           
            <p style="margin: 0"><strong>এনআইডি:</strong> {{ $data->gurdian_nid ?? '--' }}</p>
           @if ($data->id_number)
                <p style="margin: 0"><strong>আইডি নাম্বার:</strong> {{ $data->id_number ?? '--' }}</p>
           @endif
            <p style="margin: 0"><strong>সম্পর্ক:</strong> {{ $data->relation ?? '--' }}</p>
        </div>

        <div class="block">
            <h3>অভিভাবকের প্রতি</h3>
            <p>আপনার সন্তানের লেখা-পড়া ও চারিত্রিক উন্নতির লক্ষ্যে মাঝে মাঝে উস্তাদদের সাথে যোগাযোগ করুন। লেখা-পড়ার
                স্বার্থে প্রাতিষ্ঠানিক ছুটি ব্যতীত অন্য ছুটি না নেওয়াই শ্রেয়। প্রতি মাসে নির্ধারিত ফি যথাসময়ে পরিশোধ
                করুন।</p>
        </div>

        <div class="block" style="direction: ltr; text-align: left;">
            <h3>শিক্ষার্থীদের অঙ্গিকারনামা</h3>
            <ol
                style="display: flex; flex-wrap: wrap; gap: 5px; list-style-position: inside; padding-left: 0; margin: 0;">
                <li style="width: 45%; line-height: 1; margin: 0;">আমি শরীয়তের আলোকে সবকিছু মেনে চলব।</li>
                <li style="width: 50%; line-height: 1; margin: 0;">লেখা-পড়া ছাড়া অন্য কোনো ব্যস্ততা রাখব না।</li>
                <li style="width: 45%; line-height: 1; margin: 0;">উস্তাদদের সম্মান করব এবং আনুগত্য করব।</li>
                <li style="width: 50%; line-height: 1; margin: 0;">উস্তাযদের কখনো অশ্রদ্ধা বা তাঁদের সাথে বেয়াদবি করবনা।
                </li>
                <li style="width: 45%; line-height: 1; margin: 0;">কর্তৃপক্ষের অনুমতি ছাড়া মাদ্রাসার বাইরে যাব না।
                </li>
                <li style="width: 50%; line-height: 1; margin: 0;">আমি মাদরাসা কর্তৃক নির্ধারিত সকল নিয়ম-কানুন মেনে
                    চলবো।</li>
            </ol>
        </div>

        <div style="margin-top: 30px; display: flex; justify-content: space-between;">
            <div>
                <p style="margin: 0">........................................</p>
                <p style="margin: 0">শিক্ষার্থীর স্বাক্ষর</p>
            </div>
            <div>
                <p style="margin: 0">........................................</p>
                <p style="margin: 0">অভিভাবকের স্বাক্ষর</p>
            </div>
            <div>
                <p style="margin: 0">........................................</p>
                <p style="margin: 0">মুহতামিমের অনুমোদন</p>
            </div>
        </div>




        <div class="section">
            <img src="{{ asset('img/' . $invoice->invoice_footer) }}" alt="Footer" class="footer-img">
        </div>

    </div>

    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>

</html>
