@extends('dashboard.master')
@section('title', 'Book Distribute Details')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Book Distribute Details</b>
					</span>
				</div>

				<div class="page-title-actions">
                    <a title="Back" href="{{ url()->previous() }}" type="button" class="btn btn-sm btn-dark">
                        <i class="fas fa-arrow-left mr-1"></i>
                        Back
                    </a>
					<a title="Create" href="{{ route('teacher.book.distribute.create') }}" type="button" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus mr-1"></i>
                        Create
                    </a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <table id="data_table" class="table table-bordered table-striped " style="width:40%">
                        <thead>
                        <tr  id="previous_tr" class="btn-light">
                            <th>Teacher</th>
                            <td>{{ $data->teacher->name ?? '' }}</td>
                        </tr>
                        @if(!empty($data->exam_id))
                        <tr  id="previous_tr" class="btn-light">
                            <th>Exam Name</th>
                            <td>{{ $data->exam->name ?? '' }}</td>
                        </tr>
                        @endif

                        @if(!empty($data->session_id))
                            <tr  id="previous_tr" class="btn-light">
                                <th>Session</th>
                                <td>{{ $data->stusession->name ?? '' }}</td>
                            </tr>
                        @endif
                        <tr  id="previous_tr" class="btn-light">
                            <th>Assigned By</th>
                            <td>{{ $data->createdBy->name ?? '' }}</td>
                        </tr>
                        <tr  id="previous_tr" class="btn-light">
                            <th>Note</th>
                            <td>{{ $data->note ?? '' }}</td>
                        </tr>

                    </thead>

                    </table> <hr>
					<table id="data_table" class="table table-bordered table-striped data-table table-hover" style="width:60%">

                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Kitab</th>
                            </tr>
                        </thead>
                        <tbody>

                        @foreach ($subjects as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->subject->name }}</td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
				</div>
			</div>
		</div>
	</section>
</div>

@endsection
