<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teacher Discharge</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
      <?php
    $invoiceBgPath = 'back_height.jpg';
    if (isset($design->invoice_bg) && !empty($design->invoice_bg)) {
        $potentialBgFile = 'img/' . $design->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <!-- Custom CSS -->
    <style>
        /* Resetting some default styles */
        body, h2, p {
            margin: 0;
            padding: 0;
        }

        /* Set page size to A4 */
        @page {
            size: A4;
            margin: 0;
        }

        /* Ensure the content fits in A4 format */
        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .container {
            padding: 20px;
            flex-grow: 1; /* Ensures the content takes up the available space, leaving footer at the bottom */
        }

        /* Header Styling */
        .company-header {
            width: 100% !important;
            height: auto;
            margin-bottom: 20px;
        }

        .company-header img {
            width: 100% !important; /* Make the header image span the width of the container */
            height: 100%; /* Fixed height of 120px */
            object-fit: cover; /* Ensure the image scales without stretching */
        }

        .company-header p {
            font-size: 14px;
            color: #666;
            text-align: center;
        }

        /* Invoice Table Styling */
        table {
            width: 100%;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 10px;
            text-align: right;
            border: 1px solid #ddd;
        }

        table th {
            background-color: #f8f8f8;
        }

        /* Signature Section */
        .signature-section {
            font-size: 14px;
            color: #333;
        }

        .signature-section .row {
            margin-top: 50px;
        }

        .signature-section .col-6 p {
            margin-top: 10px;
            font-weight: bold;
        }

        /* Footer Styling */
        .company-footer {
            width: 100%;
            height: auto;
            margin-top: 20px;
            position: absolute;
            bottom: 0;
        }

        .company-footer img {
            width: 100%; /* Make the footer image span the width of the container */
            height: 100%; /* Fixed height of 120px */
            object-fit: cover; /* Ensure the image scales without stretching */
        }

        /* Footer Copyright Text */
        .company-footer p {
            font-size: 12px;
            color: #333;
            text-align: center;
        }

        

    </style>
</head>
<body>
    <!-- Header -->
    <header class="company-header">
        @if($design && $design->invoice_header)
        <img src="{{ asset('img/' . $design->invoice_header) }}" alt="Header Image">
        @endif
    </header>

    <div class="container my-5" style="max-width: 21cm; min-width: 14.8cm;">
        <div class="invoice">
            <div class="row">
                <div class="col-6">
                    <h6>Discharge Paper</h6>
                    <p><strong>ID: </strong>{{ $data->reg_no ?? '--' }}</p>
                    <p><strong>Name:</strong> {{ $data->name ?? '--' }}</p>
                </div>
                <div class="col-6 text-right">
                    <p><strong>Date:</strong> {{ now()->format('d/m/Y') }}</p>
                </div>
            </div>

            <div class="container">
                # {{ $data->discharge_note ?? '' }}
            </div>

            <!-- Signature Section -->
            <div class="signature-section mt-5">
                <div class="row">
                    <div class="col-6">
                        <p> ________________________<br>
                        <strong>Teacher's Signature:</strong>
                        </p>
                    </div>
                    <div class="col-6 text-right">
                        <p>  __________________________<br>
                        <strong>Principal's Signature:</strong>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="company-footer">
        @if($design && $design->invoice_footer)
        <img src="{{ asset('img/' . $design->invoice_footer) }}" alt="Footer Image">
        @endif
    </footer>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script type="text/javascript">
        localStorage.clear();
        function auto_print() {
            window.print()
        }
        setTimeout(auto_print, 1000);
    </script>
</body>
</html>
