<!DOCTYPE html>
<html lang="bn">

<head>
    <meta charset="UTF-8">
    <title>Teacher ID Card</title>

    <?php
    
    $invoiceBgPath = 'back_height.jpg';
    
    if (isset($design->invoice_bg) && !empty($design->invoice_bg)) {
        $potentialBgFile = 'img/' . $design->invoice_bg;
        if (file_exists(public_path($potentialBgFile))) {
            $invoiceBgPath = $potentialBgFile;
        }
    }
    ?>
    <style>
        @page {
            size: A6;
            margin: 5mm 1mm;
            /* Increased top margin to 5mm */
        }

        body {
            font-family: 'Noto Sans Bengali', sans-serif;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            height: 100vh;
            gap: 10mm;
            background: #eaeaea;
        }

        .card {
            width: 74mm;
            height: 105mm;
            box-sizing: border-box;
            padding: 10px;
            border: 2px solid goldenrod;
            border-radius: 8px;
            background-image: url('{{ asset($invoiceBgPath) }}');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            position: relative;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
            color: #000;
            margin-top: 5mm;
            /* Added margin to top */
        }

        .logo {
            width: 50px;
            height: 50px;
            margin: 5px auto;
            /* Reduced top margin */
            display: block;
            border-radius: 50%;
            background-image: url('{{ asset('img/' . $setting->logo) }}');
            background-size: cover;
            background-position: center;
        }

        /* Rest of your CSS remains the same */
        .header {
            text-align: center;
            font-size: 11px;
            color: darkgreen;
            font-weight: bold;
            margin-bottom: 3px;
            line-height: 1.4;
        }

        .sub-header {
            text-align: center;
            font-size: 10px;
            font-weight: normal;
            color: #333;
            margin-bottom: 8px;
        }

        .photo {
            width: 70px;
            height: 80px;
            border-radius: 4px;
            border: 2px solid #000;
            margin: 0 auto;
            background-image: url('{{ asset('backend/img/teacher/' . $data->image) }}');
            background-size: cover;
            background-position: center;
        }

        .name {
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            margin-top: 6px;
            margin-bottom: 14px;
        }

        .info {
            font-size: 14px;
            line-height: 1.6;
            padding-left: 10px;
        }

        .notice {
            font-size: 13px;
            text-align: center;
            font-weight: bold;
            padding: 6px;
            margin: 12px auto;
            border: 2px solid goldenrod;
            border-radius: 6px;
            background-color: #fff8dc;
            width: 90%;
        }

        .title {
            text-align: center;
            font-size: 12px;
            font-weight: bold;
            line-height: 1.6;
            margin-top: 10px;
        }

        .event {
            text-align: center;
            font-size: 12px;
            margin-top: 15px;
            line-height: 1.5;
            margin-bottom: 15px;
        }

        .condition {
            text-align: center;
            font-size: 12px;
            color: red;
            font-weight: bold;
            background-color: #fff;
            border: 1px solid #000;
            padding: 6px;
            width: 95%;
            margin: 0 auto;
            border-radius: 4px;
            line-height: 1.5;
        }
    </style>
</head>

<body>

    <!-- Front Side -->
    <div class="card">
        {{-- <div class="logo"></div>
        <div class="header"> {{ $setting->long_name ?? '' }}</div>
        <div class="sub-header"> {{ $setting->address ?? '' }}</div> --}}
         @if ($design && $design->invoice_header)
            <img style="width: 100%" src="{{ asset('img/' . $design->invoice_header) }}" alt="Header Image">
        @endif
        <div class="photo"></div>
        <div class="name">{{ $data->name ?? '' }}</div>
        <div class="info">
            আইডি নং: {{ $data->user_id ?? '' }}<br>
            পদবী: {{ $data->designation ?? '' }}<br>
            রক্তের গ্ৰুপ: {{ $data->blood_group ?? '' }}<br>
            মোবাইল: {{ $data->phone ?? '' }}<br>
            @php
                $cardNumbers = json_decode($data->card_no);
            @endphp
            @if (is_array($cardNumbers) && !empty($cardNumbers))
                পরিচয় পত্র: {{ $cardNumbers[0] }}
            @endif
        </div>
    </div>

    <!-- Back Side -->
    <div class="card">
        {{-- <div class="logo"></div> --}}
         @if ($design && $design->invoice_header)
            <img style="width: 100%" src="{{ asset('img/' . $design->invoice_header) }}" alt="Header Image">
        @endif

        <div class="notice">
            ব্যবহারকারী ব্যতীত এই কার্ডটি অন্য কোথাও পাওয়া গেলে<br>
            মাদ্রাসার ঠিকানায় ফেরত দেওয়ার অনুরোধ রইল।
        </div>

        <div class="title">
            {{ $setting->long_name ?? '' }}
        </div>

        <div class="event">
            {{ $setting->address ?? '' }}<br>
            ইস্যু তারিখ: {{ \Carbon\carbon::parse($data->date)->format('d/m/Y') ?? '' }} ইং<br>
            মেয়াদকাল: {{ \Carbon\Carbon::parse($data->date)->addYears(1)->format('d/m/Y') ?? '' }} ইং
        </div>

        <div class="condition">
            রাষ্ট্রদ্রোহী কাজে জড়িত না থাকার শর্তে<br>
            শুধুমাত্র শিক্ষকতাকালীন সময়ের জন্য প্রযোজ্য
        </div>
    </div>
    <script type="text/javascript">
        localStorage.clear();

        function auto_print() {
            window.print()
        }
        setTimeout(auto_print, 1000);
    </script>
</body>

</html>
