@extends('dashboard.master')
@section('title', 'Edit Teacher Responsibility')
@push('name')
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/css/toastr.css" rel="stylesheet" />
@endpush
@section('content')
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Teacher Responsibility</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
					<form enctype="multipart/form-data" action="{{ route('teacher.responsibility.update', $data->teacher_id) }}" method="POST">
						@csrf
                        @method('PUT')
						<div class="row">

							<div class="col-sm-4">
								<div class="form-group">
									<label for="teacher_id">Teacher<span class="text-red">*</span></label>
									<select name="teacher_id" id="teacher_id" class="form-control" required>
                                        <option value="">Choose One</option>
                                       @foreach($teachers as $item)
                                       <option value="{{ $item->id }}" @if($item->id == $data->teacher_id) selected @endif>{{ $item->name }} || {{ $item->phone }} || {{ $item->reg_no }} </option>
                                       @endforeach
                                    </select>
								</div>
							</div>

							<div class="col-sm-8">
								<div class="form-group">
									<label for="note">Note</label>
									<textarea name="note" id="note" class="form-control" rows="1">{{ $data->note ?? '' }}</textarea>
								</div>
							</div>

						</div>

                        <hr>

                        <div class="row col-md-12">
                            <hr>
                            <table id="data_table" class="table table-bordered table-striped data-table table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Responsibility</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($responsibilities as $item)
                                    <tr>
                                        <td width="5%">{{ $loop->iteration }}</td>
                                        <td>
                                            <div class="d-flex radio radio-info radio-inline">
                                                <input style="height: 20px !important; width:20px !important;"
                                                    type="checkbox"
                                                    name="responsibility_id[]"
                                                    class="form-control"
                                                    value="{{ $item->id }}"
                                                    id="responsibility_id"
                                                    @if($assignRes->contains('responsibility_id', $item->id)) checked @endif>
                                                <p style="margin-top:-4px; margin-left:6px">{{ $item->name }}</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>

						<div class="row mt-20">
							<div class="col-sm-12">
								<button title="Update" type="submit" class="btn btn-primary mr-2">Update</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://code.jquery.com/ui/1.13.1/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.0/js/toastr.js"></script>
<script>
    @if(Session::has('success'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true,
        "timeOut" : 1000
    };

    toastr.success("{{ session('success') }}");
  @endif

 @if(Session::has('error'))
    toastr.options =
    {
        "closeButton" : true,
        "progressBar" : true
    };
    toastr.error("{{ session('error') }}");
 @endif
</script>
@endpush
@endsection


