@extends('dashboard.master')
@section('title', 'Edit Teacher Salary Increment')
@section('content')

<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Edit Teacher Salary Increment</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ route('salary-increment.index') }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('salary-increment.update', $data->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
							<div class="col-sm-4">
								<div class="form-group">
									<label for="teacher_id">Teacher ID<span class="text-red">*</span></label>
									<input type="text" name="reg_no" value="{{ $data->reg_no }}" class="form-control" readonly>
									<input type="hidden" name="teacher_id" id="teacher_id" value="{{ $data->teacher_id }}" class="form-control" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name">Teacher Name<span class="text-red">*</span></label>
									<input type="text" name="name" id="name" value="{{ $data->name }}" class="form-control" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="department">Department<span class="text-red">*</span></label>
                                    <input type="text" name="department" id="department" value="{{ $data->teacher->departments->department_name }}" class="form-control" readonly>
									<input type="hidden" name="department_id" value="{{ $data->teacher->departments->id }}" class="form-control" readonly>
									<input type="hidden" name="designation" value="{{ $data->teacher->designation }}" class="form-control" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="salary">Previous Salary <span class="text-red">*</span></label>
									<input type="text" name="previous_salary" id="previous_salary" value="{{ $data->previous_salary }}" class="form-control salary" readonly>
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="current_salary">Current Salary <span class="text-red">*</span></label>
									<input type="text" name="current_salary" id="current_salary" value="{{ $data->current_salary }}" class="form-control" readonly>
								</div>
							</div>

                            <div class="col-sm-4">
								<div class="form-group">
									<label for="date"> Date <span class="text-red">*</span></label>
									<input type="date" name="date" id="date" value="{{ $data->date }}" class="form-control datepicker @error('date') is-invalid @enderror" placeholder="Enter date" required>

									@error('date')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror

								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="increment_amount">Increment Amount<span class="text-red">*</span></label>
									<input type="number" value="{{ $data->increment_amount }}" name="increment_amount" id="increment_amount" class="form-control salary" placeholder="Enter increment amount" required>

                                    @error('increment_amount')
									<span class="text-danger" role="alert">
										<p>{{ $message }}</p>
									</span>
									@enderror
								</div>
							</div>

							<div class="col-sm-8">
								<div class="form-group">
									<label for="increment_reason">Increment Reason<span class="text-red">*</span></label>
                                    <textarea name="increment_reason" id="increment_reason" class="form-control" cols="2" rows="1" required>{{ $data->increment_reason }}</textarea>
								</div>
							</div>

                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2 create">Update</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>
@push('js')
<script>
    //calculation
    $("#increment_amount").on('input', function(){
            var sum = 0;
            $('.salary').each(function(){
                sum += parseFloat(this.value);
            });
            $('#current_salary').val(sum);
        })
</script>
@endpush
@endsection




