@extends('dashboard.master')
@section('title', 'Teacher Due Pay')
@section('content')
@push('css')

<style>
    .dropify-wrapper .dropify-message p {
        font-size: initial;
    }
     .swal-title{
        font-size: 17px;
        color: red;
        padding: 0;
    }
    .swal-text{
        margin-top: 5px !important;
        color: black;
        background-color: white;
        box-shadow: none;
    }
    .swal-modal{
        max-width: 299px ;
            /* width: auto !important; */
            padding-top: 1px;
            margin-top: 1px;
            padding: 1px 1px;
            vertical-align: top;
        }

</style>

 @endpush
<div class="content-wrapper">
	<div class="content-header">
		<div class="container-fluid">
			<div class="page-title-wrapper">
				<div class="page-title-heading">
					<div class="page-title-icon">
						<i class="nav-icon fas fa-mosque"></i>
					</div>
					<span>
						<b>Teacher Due Pay</b>
					</span>
				</div>

				<div class="page-title-actions">
					<a title="Back Button" href="{{ URL::previous() }}" type="button" class="btn btn-sm btn-dark">
						<i class="fas fa-arrow-left mr-1"></i>
						Back
					</a>
				</div>
			</div>
		</div>
	</div>

	<section class="content">
		<div class="container-fluid">
			<div class="card">
				<div class="card-body">
                    <form enctype="multipart/form-data" action="{{ route('salary-pay.store') }}" method="POST">
                        @csrf
                        <div class="row">

							<div class="col-sm-4">
								<div class="form-group">
									<label for="name">Teacher Name<span class="text-red">*</span></label>
									<input type="text" value="{{ $data->teachers->name ?? '' }}" class="form-control" readonly>
                                    <input type="hidden" name="teacher_id" value="{{ $data->teacher_id }}">
                                    <input type="hidden" name="transaction_type" value="7">
                                    <input type="hidden" name="transaction_purpose" value="Due Pay">
								</div>
							</div>

							<div class="col-sm-4">
								<div class="form-group">
									<label for="department">Department<span class="text-red">*</span></label>
                                    <input type="text" name="department_id" id="department_id" value="{{ $data->teachers->departments->department_name ?? '--'}}" class="form-control" readonly>
								</div>
							</div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="salary_month">Salary Month<span class="text-red">*</span></label>
                                    <input type="month" id="salary_month" name="salary_month" value="{{ $data->salary_month }}" class="form-control " readonly>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="total_amount">Total Salary</label>
                                    <input type="text" value="{{ $data->total_amount }}" class="form-control" readonly>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="salary_due">Salary Due<span class="text-red">*</span></label>
                                    <input type="text" id="salary_due" name="salary_due" value="{{ $salaryDue }}" class="form-control" readonly>
                                    <input type="hidden" name="cash_amount" class="form-control" id="cash_amount" readonly>
                                    <input type="hidden" id="bankAmount" name="bank_amount" class="form-control bank_amount" readonly>
                                    <input type="hidden" id="mobileAmount" name="mobile_amount" class="form-control mobile_amount" readonly>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="payment_method">Payment Method<span class="text-red">*</span></label>
                                    <select name="payment_method" id="payment_method" class="form-control @error('payment_method') is-invalid @enderror" required>
                                        <option value="">Select Method</option>
                                        <option value="1">Cash</option>
                                        <option value="2">Bank </option>
                                        <option value="3">Mobile Banking</option>
                                    </select>
                                    @error('payment_method')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4" id="bank_account">
                                <div class="form-group">
                                    <label for="account_id ">Account Name<span class="text-red">*</span><span class="text-primary" style="display: none" id="bank_amount"></span></label>

                                    <select name="account_id" id="account_id"  class="form-control @error('account_id ') is-invalid @enderror">
                                        <option value="">Select account</option>
                                        @foreach ($banks as $key => $bank)
                                            <option value="{{ $bank->id }}" > {{ $bank->banks->bank_name }} || {{ $bank->account_name }}  || {{ $bank->account_no }}</option>
                                        @endforeach
                                    </select>

                                     @error('account_id')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror

                                </div>
                            </div>

                            <div class="col-sm-4" id="mobile_account">
                                <div class="form-group">
                                    <label for="mobile_banking_id">Mobile Banking Account<span class="text-red">*</span><span class="text-primary" id="mobile_amount" style="display: none"></span></label>

                                    <select name="mobile_banking_id" id="mobile_banking_id" class="form-control @error('mobile_banking_id') is-invalid @enderror">
                                        <option value="">Select account</option>
                                            @foreach ($mobilebanks as $key => $mobilebank)
                                                <option value="{{ $mobilebank->id }}" >{{ $mobilebank->mobileBankings->name }} || {{ $mobilebank->account_name }} || {{ $mobilebank->mobile_no }} </option>
                                            @endforeach
                                    </select>
                                     @error('mobile_banking_id')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-4" id="transaction_id">
                                <div class="form-group">
                                    <label for="mobile_transaction_id">Transaction ID<span class="text-red">*</span></label>

                                    <input type="text" id="mobile_transaction_id" name="mobile_transaction_id" value="{{ old('mobile_transaction_id') }}"class="form-control @error('mobile_transaction_id') is-invalid @enderror" placeholder="Enter transaction id">

                                     @error('mobile_transaction_id')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror

                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="date">Date<span class="text-red">*</span></label>
                                    <input type="date" id="date" name="date" value="{{ old('date') }}"class="form-control" placeholder="Enter amount">
                                     @error('date')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror

                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="amount">Due Salary Pay<span class="text-red">*</span><span class="text-primary" id="cashBalance" > </span></label>
                                    <input type="number" id="amount" name="amount" onkeyup="Amount()" value="{{ old('amount') }}"class="form-control salary amount" placeholder="Enter amount">
                                     @error('amount')
                                    <span class="text-danger" role="alert">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror

                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <button type="submit" class="btn btn-success mr-2 create">Submit</button>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</section>
</div>

@push('js')
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js" integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer">
</script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js" integrity="sha512-Zq9o+E00xhhR/7vJ49mxFNJ0KQw1E1TMWkPTxrWcnpfEFDEXgUiwJHIKit93EW/XxE31HSI5GEOW06G6BF1AtA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
 $("#bank_account").hide();
    $("#mobile_account").hide();
    $("#transaction_id").hide();

    $("#mobile_banking_id").on('click', function(){
        var mobile_banking_id = $("#mobile_banking_id").val();
        var m = $(this).val();
        if (m < 0 ) {
            swal({
                title: `Alert!!!`,
                text: "Please create account first",
                buttons: true,
                dangerMode: true,
            });
        }
    });

    $("#account_id").on('click', function(){
        var account_id = $("#account_id").val();
        var m = $(this).val();
        if (m < 0 ) {
            swal({
                title: `Alert!!!`,
                text: "Please create account first",
                buttons: true,
                dangerMode: true,
            });
        }
    });

    $("#payment_method").on('change', function(){
        var payment_method = $("#payment_method").val();
        if ($(this).val() == 1) {
            $("#mobile_account").hide();
            $("#transaction_id").hide();
            $("#bank_account").hide();
            $("#cashBalance").show();
        }else if($(this).val() == 2){
            $("#bank_account").show();
            $("#cashBalance").hide();
            $("#mobile_account").hide();
            $("#transaction_id").hide();
        }else if($(this).val() == 3){
            $("#cashBalance").hide();
            $("#mobile_account").show();
            $("#transaction_id").show();
            $("#bank_account").hide();
        }

        var url = "{{route('current-balance')}}";
            $.ajax({
                type: "GET",
                url: url,
                dataType: 'Json',
                data: {
                    payment_method: payment_method,
                },
                 success: function(data) {
                    if(payment_method == 1){
                      $("#cashBalance").append(data.CurrentCashBalance);
                      $('#cash_amount').val(data.CurrentCashBalance);
                      $("#mobile_account").hide();
                      $("#transaction_id").hide();
                      $("#bank_account").hide();
                    }
                }
            })
    });


    //bank account current balance
    $("#account_id, #mobile_banking_id").on('change', function(e){
         e.preventDefault();

        var account_id = $("#account_id").val();
        var mobile_banking_id = $("#mobile_banking_id").val();
        var payment_method = $("#payment_method").val();

        $("#cashBalance").empty();
        $("#cash_amount").val(0);
        $("#bank_amount").empty();
        $("#bankAmount").val(0);
        $("#mobile_amount").empty();
        $("#mobileAmount").val(0);

        var url = "{{route('current-balance')}}";
            $.ajax({
                type: "GET",
                url: url,
                dataType: 'Json',
                data: {
                    account_id: account_id,
                    mobile_banking_id: mobile_banking_id,
                },
                 success: function(data) {
                    console.log(data);
                    if(payment_method == 2){
                      $("#bank_account").show();
                      $("#bank_amount").show();
                      $("#cashBalance").hide();
                      $("#bankAmount").val(data.CurrentBankAmount);
                      $("#bank_amount").append(data.CurrentBankAmount);
                    }else if (payment_method == 3){
                      $("#cashBalance").hide();
                      $("#mobile_account").show();
                      $("#mobile_amount").show();
                      $("#transaction_id").show();
                      $("#mobileAmount").val(data.CurrentMobileBalance);
                      $("#mobile_amount").append(data.CurrentMobileBalance);
                    }
                }
            })
        })

        function Amount(){
            var bankAmount= parseFloat($('#bank_amount').html());
            var mobileAmount = parseFloat($('#mobile_amount').html());
            var dueAmount= parseFloat($('#salary_due').val());
            var cashBalance = parseFloat($('#cashBalance').html());

            // amount validation
            if( cashBalance < dueAmount){
                swal({
                        title: `Alert!!!`,
                        text: "You don't have sufficient balance",
                        buttons: true,
                        dangerMode: true,
                    }).then((errorMessage) => {
                        if (errorMessage) {
                            $('.amount').val(0);
                        }
                    });
                }

            if(bankAmount < dueAmount){
                swal({
                        title: `Alert!!!`,
                        text: "You don't have sufficient balance",
                        buttons: true,
                        dangerMode: true,
                    }).then((errorMessage) => {
                        if (errorMessage) {
                            $('.amount').val(0);
                        }
                    });
                }

            if(mobileAmount < dueAmount){
                swal({
                        title: `Alert!!!`,
                        text: "You don't have sufficient balance",
                        buttons: true,
                        dangerMode: true,
                    }).then((errorMessage) => {
                        if (errorMessage) {
                            $('.amount').val(0);
                        }
                    });
                }
           }


    $("#amount").on('input', function(event){
        event.preventDefault();
        salary_due =  parseFloat($('#salary_due').val());
        amount =  parseFloat($('#amount').val());

        if(amount > salary_due ){
        swal({
                title: `Alert!!!`,
                text: "Pay amount is more than due amount",
                buttons: true,
                dangerMode: true,
            }).then((errorMessage) => {
                if (errorMessage) {
                    $('#amount').val(0);
                }
            });
      }
    })

</script>
@endpush
@endsection




